/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.table;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.table.ITableColumn;
import de.intarsys.tools.table.TableColumnFunction;

public class TableColumn
implements ITableColumn,
IElementConfigurable,
IElementSerializable {
    private static final String ATTR_CLASS = "class";
    private static final String EL_FUNCTION = "function";
    private static final String ATTR_NAME = "name";
    private String name;
    private TableColumnFunction function;

    public TableColumn() {
    }

    public TableColumn(String name) {
        this.name = name;
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setName(ElementTools.getString((IElement)element, (String)ATTR_NAME, (String)this.getName()));
        IElement elRenderer = element.element(EL_FUNCTION);
        try {
            this.setFunction((TableColumnFunction)ElementTools.createObject((IElement)elRenderer, TableColumnFunction.class, (Object)this, (IArgs)Args.create()));
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public String getContent() {
        if (this.getFunction() == null) {
            return "-";
        }
        return this.getFunction().getLabel();
    }

    public TableColumnFunction getFunction() {
        return this.function;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue(ATTR_CLASS, this.getClass().getName());
        element.setAttributeValue(ATTR_NAME, this.getName());
        if (this.getFunction() != null) {
            IElement elRenderer = element.newElementMapped(EL_FUNCTION);
            this.getFunction().serialize(elRenderer);
        }
    }

    public void setFunction(TableColumnFunction renderer) {
        this.function = renderer;
    }

    public void setName(String name) {
        this.name = name;
    }
}

