/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.freetype;

import de.intarsys.cwt.common.ShapeWrapper;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.freetype.GlyphSlot;
import de.intarsys.cwt.freetype.Outline;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.freetype.FreetypeFont;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;
import de.intarsys.tools.geometry.ApplyTransformationShape;
import de.intarsys.tools.geometry.TransformedShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class FreetypeGlyphs
implements IPlatformGlyphs {
    private static final Shape EMPTY = new GeneralPath();
    private final FreetypeFont font;
    private final PDGlyphs glyphs;
    private Shape shape;
    private int width;

    protected FreetypeGlyphs(FreetypeFont font, PDGlyphs glyphs) throws PlatformFontException {
        this.font = font;
        this.glyphs = glyphs;
        this.init();
    }

    protected void createContour(GeneralPath path, Outline outline, int start, int end) {
        boolean reverse = outline.isReverseFill();
        float initialX = 0.0f;
        float initialY = 0.0f;
        float cx1 = 0.0f;
        float cy1 = 0.0f;
        float cx2 = 0.0f;
        float cy2 = 0.0f;
        int cCount = 0;
        boolean newContour = true;
        int pointIndex = start;
        while (true) {
            byte tag = outline.getTag(pointIndex);
            int px = outline.getPointX(pointIndex);
            int py = outline.getPointY(pointIndex);
            float x = px;
            float y = py;
            if (newContour) {
                initialX = x;
                initialY = y;
                path.moveTo(x, y);
            } else if ((tag & 1) != 0) {
                if (cCount == 0) {
                    path.lineTo(x, y);
                } else if (cCount == 1) {
                    path.quadTo(cx1, cy1, x, y);
                } else {
                    path.curveTo(cx1, cy1, cx2, cy2, x, y);
                }
                cCount = 0;
            } else {
                if ((tag & 2) == 0 && cCount == 1) {
                    float midX = cx1 + (x - cx1) / 2.0f;
                    float midY = cy1 + (y - cy1) / 2.0f;
                    path.quadTo(cx1, cy1, midX, midY);
                    cCount = 0;
                }
                if (cCount == 0) {
                    cx1 = x;
                    cy1 = y;
                    cCount = 1;
                } else {
                    cx2 = x;
                    cy2 = y;
                    cCount = 2;
                }
            }
            newContour = false;
            if (reverse) {
                if (--pointIndex < start) {
                    pointIndex = end;
                }
                if (pointIndex != start) continue;
                break;
            }
            if (pointIndex == end) break;
            ++pointIndex;
        }
        if (cCount == 0) {
            path.lineTo(initialX, initialY);
        } else if (cCount == 1) {
            path.quadTo(cx1, cy1, initialX, initialY);
        } else {
            path.curveTo(cx1, cy1, cx2, cy2, initialX, initialY);
        }
        path.closePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Shape createShape() {
        FreetypeFont freetypeFont = this.font;
        synchronized (freetypeFont) {
            GlyphSlot slot;
            try {
                slot = this.loadGlyphSlot();
            }
            catch (PlatformFontException e) {
                return EMPTY;
            }
            Outline outline = slot.getOutline();
            int numContours = outline.getNumContours();
            if (numContours == 0) {
                return EMPTY;
            }
            int rule = outline.isEvenOddFill() ? 0 : 1;
            GeneralPath tempShape = new GeneralPath(rule, 40);
            ShapeWrapper iShape = new ShapeWrapper((Shape)tempShape);
            int contourStart = 0;
            for (int i = 0; i < numContours; ++i) {
                int contourEnd = outline.getContour(i);
                this.createContour(tempShape, outline, contourStart, contourEnd);
                contourStart = contourEnd + 1;
            }
            return iShape;
        }
    }

    public FreetypeFont getFont() {
        return this.font;
    }

    public PDGlyphs getGlyphs() {
        return this.glyphs;
    }

    public IPlatformFont getPlatformFont() {
        return this.font;
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = this.createShape();
        }
        return this.shape;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws PlatformFontException {
        FreetypeFont freetypeFont = this.font;
        synchronized (freetypeFont) {
            GlyphSlot slot = this.loadGlyphSlot();
            long advance = slot.getLinearHoriAdvance();
            if (advance == 0L) {
                advance = slot.getGlyphMetrics().getHoriAdvance();
            }
            int glyphWidth = (int)((double)advance * this.getFont().getTextSpaceFactor());
            this.setWidth(glyphWidth);
        }
    }

    protected GlyphSlot loadGlyphSlot() throws PlatformFontException {
        return this.getFont().loadGlyphSlot(this.getGlyphs());
    }

    public void render(ICSPlatformDevice device) {
        Shape glyphShape = this.getShape();
        if (glyphShape == EMPTY) {
            return;
        }
        GraphicsState graphicsState = device.getGraphicsState();
        IGraphicsContext gc = device.getGraphicsContext();
        AffineTransform fontTransform = (AffineTransform)graphicsState.getAttribute((Object)FreetypeFont.ATTR_TRANSFORM);
        TransformedShape tempShape = ApplyTransformationShape.create((Shape)glyphShape, (AffineTransform)fontTransform);
        int mode = graphicsState.textState.renderingMode & 3;
        if (mode == 0) {
            gc.fill((Shape)tempShape);
        } else if (mode == 1) {
            gc.draw((Shape)tempShape);
        } else if (mode == 2) {
            gc.fill((Shape)tempShape);
            gc.draw((Shape)tempShape);
        }
        if ((graphicsState.textState.renderingMode & 4) == 4) {
            device.addTextClip((Shape)tempShape);
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

