/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.action;

import de.intarsys.tools.action.Action;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.reflect.ObjectCreationException;

public class FunctorAction
extends Action
implements INotificationListener {
    private IFunctor checkedFunctor;
    private IFunctor enabledFunctor;
    private IFunctor effectFunctor;

    public static boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return ((String)object).equalsIgnoreCase("true");
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        return false;
    }

    public FunctorAction() {
    }

    public FunctorAction(Object owner) {
        super(owner);
    }

    public FunctorAction(Object owner, boolean checked) {
        super(owner, checked);
    }

    public FunctorAction(String id, Object owner) {
        super(id, owner);
    }

    public FunctorAction(String id, Object owner, boolean checked) {
        super(id, owner, checked);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        try {
            IFunctor<?> functor;
            IElement functorElement = element.element("effect");
            if (functorElement != null) {
                functor = ElementTools.createFunctor(this.getOwner(), functorElement, null, this.getOwner());
                this.setEffectFunctor(functor);
            }
            if ((functorElement = element.element("checked")) != null) {
                functor = ElementTools.createFunctor(this.getOwner(), functorElement, null, this.getOwner());
                this.setCheckedFunctor(functor);
            }
            if ((functorElement = element.element("enabled")) != null) {
                functor = ElementTools.createFunctor(this.getOwner(), functorElement, null, this.getOwner());
                this.setEnabledFunctor(functor);
            }
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException(e);
        }
    }

    public IFunctor getCheckedFunctor() {
        return this.checkedFunctor;
    }

    public IFunctor getEffectFunctor() {
        return this.effectFunctor;
    }

    public IFunctor getEnabledFunctor() {
        return this.enabledFunctor;
    }

    public void handleEvent(Event event) {
        this.triggerChange(null);
    }

    @Override
    public boolean isChecked(IFunctorCall call) {
        IFunctor functor = this.getCheckedFunctor();
        if (functor != null) {
            try {
                if (this.getOwner() != null) {
                    call.setReceiver(this.getOwner());
                }
                return FunctorAction.toBoolean(functor.perform(call));
            }
            catch (FunctorException e) {
                return false;
            }
        }
        return super.isChecked(call);
    }

    @Override
    public boolean isEnabled(IFunctorCall call) {
        IFunctor functor = this.getEnabledFunctor();
        if (functor != null) {
            try {
                if (this.getOwner() != null) {
                    call.setReceiver(this.getOwner());
                }
                return FunctorAction.toBoolean(functor.perform(call));
            }
            catch (FunctorException e) {
                return false;
            }
        }
        return super.isEnabled(call);
    }

    @Override
    public Object perform(IFunctorCall call) throws FunctorException {
        IFunctor functor = this.getEffectFunctor();
        if (functor != null) {
            if (this.getOwner() != null) {
                call.setReceiver(this.getOwner());
            }
            return functor.perform(call);
        }
        return super.perform(call);
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        IElement child;
        super.serialize(element);
        if (this.effectFunctor instanceof IElementSerializable) {
            child = element.newElementMapped("effect");
            ((IElementSerializable)((Object)this.effectFunctor)).serialize(child);
        }
        if (this.checkedFunctor instanceof IElementSerializable) {
            child = element.newElementMapped("checked");
            ((IElementSerializable)((Object)this.checkedFunctor)).serialize(child);
        }
        if (this.enabledFunctor instanceof IElementSerializable) {
            child = element.newElementMapped("enabled");
            ((IElementSerializable)((Object)this.enabledFunctor)).serialize(child);
        }
    }

    public void setCheckedFunctor(IFunctor functor) {
        this.checkedFunctor = functor;
        if (this.checkedFunctor instanceof INotificationSupport) {
            ((INotificationSupport)((Object)this.checkedFunctor)).addNotificationListener(AttributeChangedEvent.ID, this);
        }
        this.setCheckStyleOn();
    }

    public void setEffectFunctor(IFunctor functor) {
        this.effectFunctor = functor;
        if (this.effectFunctor instanceof INotificationSupport) {
            ((INotificationSupport)((Object)this.effectFunctor)).addNotificationListener(AttributeChangedEvent.ID, this);
        }
    }

    public void setEnabledFunctor(IFunctor functor) {
        this.enabledFunctor = functor;
        if (this.enabledFunctor instanceof INotificationSupport) {
            ((INotificationSupport)((Object)this.enabledFunctor)).addNotificationListener(AttributeChangedEvent.ID, this);
        }
    }

    @Override
    public String toString() {
        try {
            return "FunctorAction '" + this.getId() + "'";
        }
        catch (RuntimeException e) {
            return "<unprintable FunctorAction>";
        }
    }
}

