/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.PACKAGE;
import de.intarsys.tools.activity.Requester;
import de.intarsys.tools.message.CommonMessages;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.valueholder.IValueHolder;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestConfirmation<P extends IActivity<?>>
extends Requester<IMessage, P> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final IMessage OPTION_OK = Msg.getMessage("RequestConfirmation.ok", new Object[0]);
    public static final IMessage OPTION_CANCEL = Msg.getMessage("RequestConfirmation.cancel", new Object[0]);
    public static final IMessage OPTION_YES = Msg.getMessage("RequestConfirmation.yes", new Object[0]);
    public static final IMessage OPTION_NO = Msg.getMessage("RequestConfirmation.no", new Object[0]);
    public static final IMessage OPTION_PROCEED = Msg.getMessage("RequestConfirmation.proceed", new Object[0]);
    protected static final IMessage[] OPTIONS_OK = new IMessage[]{OPTION_OK};
    protected static final IMessage[] OPTIONS_CANCEL = new IMessage[]{OPTION_CANCEL};
    protected static final IMessage[] OPTIONS_OK_CANCEL = new IMessage[]{OPTION_OK, OPTION_CANCEL};
    protected static final IMessage[] OPTIONS_YES_NO = new IMessage[]{OPTION_YES, OPTION_NO};
    protected static final IMessage[] OPTIONS_YES_NO_CANCEL = new IMessage[]{OPTION_YES, OPTION_NO, OPTION_CANCEL};
    private static final Logger Log = LoggerFactory.getLogger(RequestConfirmation.class);
    private final IMessage[] options;
    private IMessage selection;
    private IMessage defaultOption;

    public static IMessage choose(IActivity<?> parent, IMessage title, IMessage message, int severity, IMessage[] options, IMessage defaultOption, IMessage toggleMessage, IValueHolder<Boolean> toggleValue) {
        RequestConfirmation<?> confirm = RequestConfirmation.create(parent, title, message, severity, options, defaultOption, toggleMessage, toggleValue);
        confirm.enter();
        return (IMessage)confirm.getAnyway();
    }

    public static RequestConfirmation<?> create(IActivity<?> parent, IMessage title, IMessage message, int severity, IMessage[] options, IMessage defaultOption, IMessage toggleMessage, IValueHolder<Boolean> toggleValue) {
        RequestConfirmation confirm = new RequestConfirmation(parent, options);
        confirm.setTitle(title);
        confirm.setMessage(message);
        confirm.setSeverity(severity);
        if (defaultOption == null) {
            defaultOption = options[0];
        }
        if (!Arrays.asList(options).contains(defaultOption)) {
            throw new IllegalArgumentException("unsuitable default option");
        }
        confirm.setDefaultOption(defaultOption);
        confirm.setModal(true);
        confirm.setToggleMessage(toggleMessage);
        confirm.setToggleValue(toggleValue);
        return confirm;
    }

    public static IMessage[] getOptionsCancel() {
        return (IMessage[])OPTIONS_CANCEL.clone();
    }

    public static IMessage[] getOptionsOk() {
        return (IMessage[])OPTIONS_OK.clone();
    }

    public static IMessage[] getOptionsOkCancel() {
        return (IMessage[])OPTIONS_OK_CANCEL.clone();
    }

    public static IMessage[] getOptionsYesNo() {
        return (IMessage[])OPTIONS_YES_NO.clone();
    }

    public static IMessage[] getOptionsYesNoCancel() {
        return (IMessage[])OPTIONS_YES_NO_CANCEL.clone();
    }

    public static void prompt(IActivity<?> parent, IMessage title, IMessage message, int severity) {
        RequestConfirmation<?> confirm = RequestConfirmation.create(parent, title, message, severity, OPTIONS_OK, OPTION_OK, null, null);
        confirm.setBlock(false);
        try {
            confirm.enter();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IMessage requestAcknowledge(IActivity<?> parent, IMessage title, IMessage message, int severity) {
        return RequestConfirmation.choose(parent, title, message, severity, OPTIONS_OK, OPTION_OK, null, null);
    }

    public static IMessage requestAcknowledge(IActivity<?> parent, IMessage title, IMessage message, int severity, IMessage toggleMessage, IValueHolder<Boolean> toggleValue) {
        return RequestConfirmation.choose(parent, title, message, severity, OPTIONS_OK, OPTION_OK, toggleMessage, toggleValue);
    }

    public static IMessage requestAcknowledge(IActivity<?> parent, String code) {
        IMessage message = ((IMessageBundleSupport)((Object)parent)).getMessageBundle().getMessage(code, new Object[0]);
        return RequestConfirmation.requestAcknowledge(parent, CommonMessages.EMPTY, message, 10);
    }

    public static IMessage requestConfirm(IActivity<?> parent, IMessage title, IMessage message, IMessage defaultOption) {
        return RequestConfirmation.choose(parent, title, message, 10, OPTIONS_OK_CANCEL, defaultOption, null, null);
    }

    public static IMessage requestConfirm(IActivity<?> parent, IMessage title, IMessage message, IMessage defaultOption, IMessage toggleMessage, IValueHolder<Boolean> toggleValue) {
        return RequestConfirmation.choose(parent, title, message, 10, OPTIONS_OK_CANCEL, defaultOption, toggleMessage, toggleValue);
    }

    public static IMessage requestYesNo(IActivity<?> parent, IMessage title, IMessage message, IMessage defaultOption) {
        return RequestConfirmation.choose(parent, title, message, 10, OPTIONS_YES_NO, defaultOption, null, null);
    }

    public static IMessage requestYesNo(IActivity<?> parent, IMessage title, IMessage message, IMessage defaultOption, IMessage toggleMessage, IValueHolder<Boolean> toggleValue) {
        return RequestConfirmation.choose(parent, title, message, 10, OPTIONS_YES_NO, defaultOption, toggleMessage, toggleValue);
    }

    public static IMessage requestYesNoCancel(IActivity<?> parent, IMessage title, IMessage message, IMessage defaultOption) {
        return RequestConfirmation.choose(parent, title, message, 10, OPTIONS_YES_NO_CANCEL, defaultOption, null, null);
    }

    public static IMessage requestYesNoCancel(IActivity<?> parent, IMessage title, IMessage message, IMessage defaultOption, IMessage toggleMessage, IValueHolder<Boolean> toggleValue) {
        return RequestConfirmation.choose(parent, title, message, 10, OPTIONS_YES_NO_CANCEL, defaultOption, toggleMessage, toggleValue);
    }

    public RequestConfirmation(P parent, IMessage[] options) {
        super(parent);
        this.options = options;
        this.defaultOption = options[0];
    }

    public IMessage getDefaultOption() {
        return this.defaultOption;
    }

    public int getDefaultOptionIndex() {
        for (int i = 0; i < this.options.length; ++i) {
            if (this.options[i] != this.defaultOption) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected IMessage getDefaultResult() {
        return this.getSelection();
    }

    public IMessage[] getOptions() {
        return this.options;
    }

    public IMessage getSelection() {
        return this.selection;
    }

    @Override
    protected void logFinish() {
        Log.info("{} selected '{}'", (Object)this.getLogLabel(), (Object)this.getSelection());
    }

    public void setDefaultOption(IMessage defaultSelection) {
        this.defaultOption = defaultSelection;
    }

    public void setSelection(IMessage selection) {
        this.selection = selection;
    }

    public void setSelectionIndex(int index) {
        if (this.options.length <= index || 0 > index) {
            this.setSelection(null);
        } else {
            this.setSelection(this.options[index]);
        }
    }
}

