/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity;

import de.intarsys.tools.activity.CommonActivity;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IPrompter;
import de.intarsys.tools.activity.PACKAGE;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.InvocableMethod;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Requester<R, P extends IActivity<?>>
extends CommonActivity<R, P>
implements IPrompter {
    private static final Logger Log = LoggerFactory.getLogger(Requester.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final IMessage TOGGLE_MESSAGE = Msg.getMessage("Requester.ToggleMessage", new Object[0]);
    private int severity = 10;
    private IMessage message;
    private IValueHolder<Boolean> toggleValue = new ObjectHolder<Boolean>(Boolean.FALSE);
    private IMessage toggleMessage;
    private IMessage title;

    protected Requester(P parent) {
        super(parent);
    }

    @InvocableMethod
    public IMessage getMessage() {
        return this.message;
    }

    public int getSeverity() {
        return this.severity;
    }

    public IMessage getTitle() {
        return this.title;
    }

    public IMessage getToggleMessage() {
        return this.toggleMessage;
    }

    public boolean isToggleValue() {
        if (this.toggleValue == null) {
            return false;
        }
        return this.toggleValue.get();
    }

    @Override
    protected void logEnterAfter() {
        Log.info("{} request '{}', '{}'", new Object[]{this.getLogLabel(), this.getTitle(), this.getMessage()});
    }

    @Override
    public void setMessage(IMessage message) {
        IMessage oldValue = this.message;
        this.message = message;
        this.triggerChanged("message", oldValue, message);
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    @Override
    public void setTitle(IMessage title) {
        this.title = title;
    }

    public void setToggleMessage(IMessage toggleMessage) {
        this.toggleMessage = toggleMessage;
    }

    public void setToggleValue(boolean toggleValue) {
        if (this.toggleValue == null) {
            return;
        }
        this.toggleValue.set(toggleValue);
    }

    public void setToggleValue(IValueHolder<Boolean> toggleValue) {
        this.toggleValue = toggleValue;
    }
}

