/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.attribute;

import de.intarsys.tools.attribute.IAttributeSupport;

public final class AttributeMap
implements IAttributeSupport {
    private Object[] keys;
    private Object[] values;
    private int length;

    public AttributeMap() {
        this(4);
    }

    public AttributeMap(int initialCapacity) {
        this.keys = new Object[initialCapacity];
        this.values = new Object[initialCapacity];
    }

    public synchronized void clear() {
        for (int i = 0; i < this.length; ++i) {
            this.values[i] = null;
            this.keys[i] = null;
        }
        this.length = 0;
    }

    public synchronized AttributeMap copy() {
        AttributeMap copy = new AttributeMap(this.length);
        for (int i = 0; i < this.length; ++i) {
            copy.values[i] = this.values[i];
            copy.keys[i] = this.keys[i];
        }
        copy.length = this.length;
        return copy;
    }

    public Object get(Object key) {
        return this.getAttribute(key);
    }

    @Override
    public synchronized Object getAttribute(Object key) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return null;
    }

    public synchronized Object[] getKeys() {
        Object[] tempKeys = new Object[this.length];
        System.arraycopy(this.keys, 0, tempKeys, 0, this.length);
        return tempKeys;
    }

    public Object put(Object key, Object o) {
        return this.setAttribute(key, o);
    }

    public void putAll(AttributeMap other) {
        for (Object key : other.getKeys()) {
            this.put(key, other.get(key));
        }
    }

    public void putAllIfAbsent(AttributeMap other) {
        for (Object key : other.getKeys()) {
            if (this.get(key) != null) continue;
            this.put(key, other.get(key));
        }
    }

    public Object remove(Object key) {
        return this.removeAttribute(key);
    }

    @Override
    public synchronized Object removeAttribute(Object key) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            Object oldValue = this.values[i];
            --this.length;
            System.arraycopy(this.keys, i + 1, this.keys, i, this.length - i);
            System.arraycopy(this.values, i + 1, this.values, i, this.length - i);
            this.values[this.length] = null;
            this.keys[this.length] = null;
            return oldValue;
        }
        return null;
    }

    @Override
    public synchronized Object setAttribute(Object key, Object value) {
        int i;
        for (i = 0; i < this.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            Object oldValue = this.values[i];
            this.values[i] = value;
            return oldValue;
        }
        if (i >= this.values.length) {
            Object[] newKeys = new Object[this.length + 4];
            System.arraycopy(this.keys, 0, newKeys, 0, this.length);
            this.keys = newKeys;
            Object[] newValues = new Object[this.length + 4];
            System.arraycopy(this.values, 0, newValues, 0, this.length);
            this.values = newValues;
        }
        this.values[this.length] = value;
        this.keys[this.length] = key;
        ++this.length;
        return null;
    }

    public synchronized String toString() {
        StringBuilder description = new StringBuilder("{");
        for (int i = 0; i < this.length; ++i) {
            if (i > 0) {
                description.append(", ");
            }
            description.append(this.keys[i]).append("=").append(this.values[i]);
        }
        description.append("}");
        return description.toString();
    }
}

