/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.component;

import de.intarsys.tools.exception.InvalidRequestException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ReferenceCounted<T> {
    private static final Map<Class<?>, ReuserMap> reusers = new ConcurrentHashMap();
    private final Supplier<T> supplier;
    private final Consumer<T> consumer;
    private final String id;
    private T object;
    private int counter;

    public static <T> ReferenceCounted<T> get(Class<T> clazz, String id, Supplier<T> supplier, Consumer<T> consumer) {
        ReuserMap map = reusers.computeIfAbsent(clazz, key -> new ReuserMap());
        return map.get(id, supplier, consumer);
    }

    public ReferenceCounted(String id, Supplier<T> supplier, Consumer<T> consumer) {
        this.id = id;
        this.supplier = supplier;
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire() {
        ReferenceCounted referenceCounted = this;
        synchronized (referenceCounted) {
            if (this.object == null) {
                this.object = this.supplier.get();
            }
            ++this.counter;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        ReferenceCounted referenceCounted = this;
        synchronized (referenceCounted) {
            return this.object;
        }
    }

    public Consumer<T> getConsumer() {
        return this.consumer;
    }

    public int getCounter() {
        return this.counter;
    }

    public String getId() {
        return this.id;
    }

    public Supplier<T> getSupplier() {
        return this.supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object handle) {
        ReferenceCounted referenceCounted = this;
        synchronized (referenceCounted) {
            if (this.counter == 0) {
                throw new InvalidRequestException("already released");
            }
            --this.counter;
            if (this.counter == 0) {
                if (this.consumer != null) {
                    this.consumer.accept(this.object);
                }
                this.object = null;
            }
        }
    }

    static class ReuserMap {
        private Map<String, ReferenceCounted<?>> objects = new ConcurrentHashMap();

        ReuserMap() {
        }

        public <T> ReferenceCounted<T> get(String id, Supplier<T> supplier, Consumer<T> consumer) {
            return this.objects.computeIfAbsent(id, key -> new ReferenceCounted(id, supplier, consumer));
        }
    }
}

