/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.converter;

import de.intarsys.tools.converter.Canonical;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.converter.DoubleDispatchConverter;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.converter.IConverterRegistry;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.provider.Providers;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardConverterRegistry
implements IConverterRegistry {
    private static final Logger Log = LoggerFactory.getLogger(StandardConverterRegistry.class);
    private final Map<Class, IConverter> converters = new HashMap<Class, IConverter>();
    private boolean initialized;
    private boolean lookupProviders = true;

    @Override
    public <T> T convert(Object source, Class<T> targetType) throws ConversionException {
        if (source == null) {
            return null;
        }
        if (targetType == Object.class) {
            return (T)source;
        }
        if (targetType.isInstance(source)) {
            return (T)source;
        }
        IConverter converter = this.lookupConverter(targetType);
        if (converter == null) {
            Canonical canonical = ConverterRegistry.get().convert(source, Canonical.class);
            if (canonical == source) {
                throw new ConversionException("can't convert " + source.getClass().getName() + " to " + targetType);
            }
            try {
                return ConverterRegistry.get().convert(canonical, targetType);
            }
            catch (ConversionException e) {
                throw new ConversionException("can't convert " + source.getClass().getName() + " to " + targetType, e);
            }
        }
        return converter.convert(source);
    }

    protected Iterator<IConverter> findProviders() {
        return Providers.get().lookupProviders(IConverter.class);
    }

    protected void init() {
        if (!this.isLookupProviders() || this.initialized) {
            return;
        }
        this.initialized = true;
        Iterator<IConverter> ps = this.findProviders();
        while (ps.hasNext()) {
            try {
                this.registerConverter(ps.next());
            }
            catch (Throwable t) {
                Log.warn("error creating converter ({})", (Object)ExceptionTools.getMessage(t));
            }
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IConverter lookupConverter(Class targetType) {
        this.init();
        return this.converters.get(targetType);
    }

    @Override
    public synchronized void registerConverter(IConverter converter) {
        IConverter dd = this.converters.computeIfAbsent(converter.getTargetType(), c -> new DoubleDispatchConverter((Class)c));
        ((DoubleDispatchConverter)dd).registerConverter(converter);
    }

    public void setLookupProviders(boolean lookupProviders) {
        this.lookupProviders = lookupProviders;
    }

    @Override
    public synchronized void unregisterConverter(IConverter converter) {
        IConverter tempConverter = this.converters.get(converter.getTargetType());
        if (tempConverter != null) {
            ((DoubleDispatchConverter)tempConverter).unregisterConverter(converter);
        }
    }
}

