/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.digest;

import de.intarsys.tools.digest.Digest;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class NullDigester
implements IDigester {
    private static final String ALGORITHM_NAME = "NULL";
    private ByteArrayOutputStream os = new ByteArrayOutputStream(){

        @Override
        public void reset() {
            super.reset();
            Arrays.fill(this.buf, (byte)0);
        }
    };

    @Override
    public IDigest digest(byte[] bytes) {
        this.os.writeBytes(null);
        return this.digestFinal();
    }

    @Override
    public IDigest digestFinal() {
        return new NullDigest(this.os.toByteArray());
    }

    @Override
    public void digestUpdate(InputStream is) throws IOException {
        StreamTools.copy(is, this.os);
    }

    @Override
    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    @Override
    public int getDigestLength() {
        return this.os.size();
    }

    @Override
    public void reset() {
        this.os.reset();
    }

    public class NullDigest
    extends Digest {
        public NullDigest(byte[] digest) {
            super(NullDigester.ALGORITHM_NAME, digest);
        }

        @Override
        public byte[] getEncoded() throws IOException {
            return this.getBytes();
        }
    }
}

