/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.component.IIdentifiable;
import de.intarsys.tools.enumeration.CanonicalFromEnumItemConverter;
import de.intarsys.tools.enumeration.CanonicalFromEnumMetaConverter;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.MessageTools;
import java.util.HashMap;
import java.util.Map;

public abstract class EnumItem
implements IIdentifiable,
Comparable {
    private static final Map META_INSTANCES;
    private String iconName;
    private final String id;
    private Object label;
    private final int weight;
    private final EnumMeta<EnumItem> meta;

    protected static EnumMeta getMeta(Class clazz) {
        return (EnumMeta)META_INSTANCES.computeIfAbsent(clazz, tmp -> new EnumMeta(clazz));
    }

    protected EnumItem(EnumMeta pMeta, String pId, Object pLabel, int pWeight) {
        this.meta = pMeta;
        this.meta.addItem(this);
        this.id = pId;
        this.label = pLabel;
        this.weight = pWeight;
    }

    protected EnumItem(String pId) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.weight = this.meta.size();
        this.meta.addItem(this);
        this.id = pId;
        this.label = MessageTools.getMessage(this, this.id, new Object[0]);
    }

    protected EnumItem(String pId, IMessage pMessage) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.weight = this.meta.size();
        this.meta.addItem(this);
        this.id = pId;
        this.label = pMessage;
    }

    protected EnumItem(String pId, IMessage pMessage, int pWeight) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = pId;
        this.label = pMessage;
        this.weight = pWeight;
    }

    protected EnumItem(String pId, int pWeight) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = pId;
        this.label = MessageTools.getMessage(this, this.id, new Object[0]);
        this.weight = pWeight;
    }

    protected EnumItem(String pId, String pLabel) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.weight = this.meta.size();
        this.meta.addItem(this);
        this.id = pId;
        this.label = pLabel;
    }

    protected EnumItem(String pId, String pLabel, int pWeight) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = pId;
        this.label = pLabel;
        this.weight = pWeight;
    }

    public int compareTo(Object o) {
        EnumItem other = (EnumItem)o;
        return this.getWeight() - other.getWeight();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnumItem) {
            return this.meta == ((EnumItem)obj).meta && this.id.equals(((EnumItem)obj).id);
        }
        return super.equals(obj);
    }

    protected String getDefaultLabel() {
        return this.id;
    }

    public String getDescription() {
        return this.getTip();
    }

    public String getIconName() {
        return this.iconName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getLabel() {
        if (this.label instanceof IMessage) {
            return ((IMessage)this.label).getString();
        }
        return (String)this.label;
    }

    public String getLocalizedLabel() {
        return this.getLabel();
    }

    protected EnumMeta getMetaInstances() {
        return this.meta;
    }

    public String getTip() {
        return this.getLabel();
    }

    protected int getWeight() {
        return this.weight;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected void setDefault() {
        this.getMetaInstances().setDefault(this);
    }

    protected void setIconName(String iconName) {
        this.iconName = iconName;
    }

    protected void setLabel(Object label) {
        this.label = label;
    }

    public String toString() {
        return this.getLabel();
    }

    static {
        new CanonicalFromEnumItemConverter();
        new CanonicalFromEnumMetaConverter();
        META_INSTANCES = new HashMap();
    }
}

