/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.PreferencesFactory;

public class PreferencesResolver
implements IStringEvaluator {
    private IPreferences preferences;

    public PreferencesResolver(IPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public Object evaluate(String expression, IArgs pArgs) throws EvaluationException {
        IPreferences current = this.preferences;
        String[] names = expression.split("\\.", 0);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (i == names.length - 1) {
                return current.get(name);
            }
            if ((current = current.node(name)) != null) continue;
            return null;
        }
        return null;
    }

    public static class PreferencesResolverRoot
    extends PreferencesResolver {
        public PreferencesResolverRoot() {
            super(PreferencesFactory.get().getRoot());
        }
    }

    public static class PreferencesResolverMain
    extends PreferencesResolver {
        public PreferencesResolverMain() {
            super(PreferencesFactory.get().getMain());
        }
    }
}

