/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.NamespaceNotFound;
import de.intarsys.tools.functor.IArgs;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

public class ScopedResolver
implements IStringEvaluator {
    private List<IStringEvaluator> resolvers = new ArrayList<IStringEvaluator>();

    public static ScopedResolver create(IStringEvaluator ... resolvers) {
        ScopedResolver scopedResolver = new ScopedResolver();
        for (IStringEvaluator resolver : resolvers) {
            scopedResolver.addResolver(resolver);
        }
        return scopedResolver;
    }

    public ScopedResolver addResolver(IStringEvaluator resolver) {
        this.resolvers.add(resolver);
        return this;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        EvaluationException last = null;
        for (IStringEvaluator resolver : this.resolvers) {
            try {
                return resolver.evaluate(expression, args);
            }
            catch (NamespaceNotFound namespaceNotFound) {
            }
            catch (EvaluationException e) {
                last = e;
            }
        }
        if (last != null) {
            throw last;
        }
        throw new NamespaceNotFound("can't evaluate '" + expression + "'");
    }

    public boolean isEmpty() {
        return this.resolvers.isEmpty();
    }

    public IStringEvaluator popResolver() {
        if (this.resolvers.isEmpty()) {
            return null;
        }
        return this.resolvers.remove(0);
    }

    public void pushResolver(IStringEvaluator resolver) {
        this.resolvers.add(0, resolver);
    }

    public void removeResolver(IStringEvaluator resolver) {
        this.resolvers.remove(resolver);
    }

    public static class Install {
        private ScopedResolver target;
        private IStringEvaluator evaluator;

        public IStringEvaluator getEvaluator() {
            return this.evaluator;
        }

        public ScopedResolver getTarget() {
            return this.target;
        }

        @PostConstruct
        public void install() {
            this.getTarget().pushResolver(this.getEvaluator());
        }

        public void setEvaluator(IStringEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public void setTarget(ScopedResolver target) {
            this.target = target;
        }
    }
}

