/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.event.CreatedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.factory.CommonFactory;
import de.intarsys.tools.factory.IBookkeepingFactory;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.proxy.IProxy;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.List;

public class AliasFactory<T>
extends CommonFactory<T>
implements IProxy,
IBookkeepingFactory<T> {
    private IFactory<T> delegate;
    private INotificationListener<CreatedEvent> listenDelegateCreate = new INotificationListener<CreatedEvent>(){

        @Override
        public void handleEvent(CreatedEvent delegateEvent) {
            CreatedEvent event = new CreatedEvent(AliasFactory.this);
            event.setInstance(delegateEvent.getInstance());
            AliasFactory.this.triggerEvent(event);
            delegateEvent.setVeto(event.isVetoed());
            if (event.isConsumed()) {
                event.consume();
            }
        }
    };
    private int armed = 0;
    private Object armedLock = new Object();

    public AliasFactory() {
    }

    public AliasFactory(IFactory delegate, String id) {
        this.setId(id);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void arm() {
        Object object = this.armedLock;
        synchronized (object) {
            if (this.armed == 0 && this.basicGetDelegate() instanceof INotificationSupport) {
                ((INotificationSupport)((Object)this.basicGetDelegate())).addNotificationListener(CreatedEvent.ID, this.listenDelegateCreate);
            }
            ++this.armed;
        }
    }

    protected IFactory basicGetDelegate() {
        return this.delegate;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        IElement elDelegate;
        super.configure(element);
        String delegateId = element.attributeValue("delegate", null);
        if (delegateId != null) {
            this.delegate = Outlet.get().lookupFactory(delegateId);
        }
        if ((elDelegate = this.getConfiguration().element("delegate")) != null) {
            try {
                this.delegate = ElementTools.createObject(elDelegate, IFactory.class, this.getContext(), Args.create());
            }
            catch (ObjectCreationException e) {
                throw new ConfigurationException(e);
            }
        }
        if (this.delegate == null) {
            throw new ConfigurationException("missing delegate");
        }
    }

    @Override
    public T createInstance(IArgs args) throws ObjectCreationException {
        this.arm();
        try {
            T t = this.getDelegate().createInstance(args);
            return t;
        }
        finally {
            this.disarm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void disarm() {
        Object object = this.armedLock;
        synchronized (object) {
            if (this.armed == 0) {
                return;
            }
            if (this.armed == 1 && this.basicGetDelegate() instanceof INotificationSupport) {
                ((INotificationSupport)((Object)this.basicGetDelegate())).removeNotificationListener(CreatedEvent.ID, this.listenDelegateCreate);
            }
            --this.armed;
        }
    }

    @Override
    public T getActive() {
        if (this.getDelegate() instanceof IBookkeepingFactory) {
            return ((IBookkeepingFactory)this.getDelegate()).getActive();
        }
        return null;
    }

    @Override
    public final Object getAttribute(Object key) {
        if (this.basicGetDelegate() instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.basicGetDelegate())).getAttribute(key);
        }
        return super.getAttribute(key);
    }

    public IFactory<T> getDelegate() {
        return this.basicGetDelegate();
    }

    @Override
    public String getDescription() {
        if (this.getDelegate() instanceof IPresentationSupport) {
            return ((IPresentationSupport)((Object)this.getDelegate())).getDescription();
        }
        return super.getDescription();
    }

    @Override
    public String getIconName() {
        if (this.getDelegate() instanceof IPresentationSupport) {
            return ((IPresentationSupport)((Object)this.getDelegate())).getIconName();
        }
        return super.getIconName();
    }

    @Override
    public List getInstances() {
        if (this.getDelegate() instanceof IBookkeepingFactory) {
            return ((IBookkeepingFactory)this.getDelegate()).getInstances();
        }
        return new ArrayList();
    }

    @Override
    public String getLabel() {
        if (this.getDelegate() instanceof IPresentationSupport) {
            return ((IPresentationSupport)((Object)this.getDelegate())).getLabel();
        }
        return super.getLabel();
    }

    public Object getRealized() {
        return this.getDelegate();
    }

    @Override
    public Class<T> getResultType() {
        return this.getDelegate().getResultType();
    }

    @Override
    public String getTip() {
        if (this.getDelegate() instanceof IPresentationSupport) {
            return ((IPresentationSupport)((Object)this.getDelegate())).getTip();
        }
        return super.getTip();
    }

    @Override
    public final Object removeAttribute(Object key) {
        if (this.basicGetDelegate() instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.basicGetDelegate())).removeAttribute(key);
        }
        return super.removeAttribute(key);
    }

    @Override
    public final Object setAttribute(Object key, Object value) {
        if (this.basicGetDelegate() instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.basicGetDelegate())).setAttribute(key, value);
        }
        return super.setAttribute(key, value);
    }

    @Override
    public int size() {
        if (this.getDelegate() instanceof IBookkeepingFactory) {
            return ((IBookkeepingFactory)this.getDelegate()).size();
        }
        return 0;
    }
}

