/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.factory.ClassBasedFactory;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tag.Tag;
import de.intarsys.tools.tag.TagTools;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryTools {
    private static final Logger Log = LoggerFactory.getLogger(FactoryTools.class);

    protected static <T extends IFactory<?>> T basicLookupFactory(Class<T> clazz) {
        IFactory factory = null;
        try {
            if (IFactory.class.isAssignableFrom(clazz)) {
                factory = ObjectTools.createObject(clazz, IFactory.class);
                ObjectTools.initObject(factory);
                Outlet.get().registerFactory(factory.getId(), factory);
                Log.debug("created default factory '" + clazz + "'");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)factory;
    }

    protected static <T extends IFactory<?>> T basicLookupFactoryFuzzy(Class<T> clazz) {
        ClassBasedFactory factory = null;
        try {
            FactoredBy factoredBy = clazz.getAnnotation(FactoredBy.class);
            if (factoredBy != null) {
                Class<? extends IFactory> factoryClass = factoredBy.factory();
                factory = (ClassBasedFactory)FactoryTools.lookupFactory(factoryClass);
            } else if (IFactory.class.isAssignableFrom(clazz)) {
                factory = ObjectTools.createObject(clazz, IFactory.class);
                ObjectTools.initObject(factory);
                Outlet.get().registerFactory(factory.getId(), factory);
                Log.info("created default factory '" + clazz + "'");
            } else {
                factory = new ClassBasedFactory(clazz);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)factory;
    }

    public static Object cleanup(Object value) {
        String name;
        if (value == null) {
            return null;
        }
        if (value instanceof IFactory) {
            return value;
        }
        if (value instanceof String && StringTools.isEmpty(name = (String)value)) {
            return null;
        }
        return value;
    }

    public static Object createInstance(Object factoryObject, IArgs args) throws ObjectCreationException {
        IFactory factory = FactoryTools.toFactory(factoryObject);
        if (factory == null) {
            throw new ObjectCreationException("factory '" + factoryObject + "'not found");
        }
        return factory.createInstance(args);
    }

    public static <T extends IFactory<?>> T lookupFactory(Class<? extends IFactory> clazz) {
        String id = clazz.getName();
        IFactory factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            factory = FactoryTools.basicLookupFactory(clazz);
        }
        return (T)factory;
    }

    public static IFactory<?> lookupFactory(String id, ClassLoader classLoader) {
        IFactory<?> factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            try {
                Class<Object> clazz = ClassTools.createClass(id, Object.class, classLoader);
                factory = FactoryTools.basicLookupFactory(clazz);
            }
            catch (ObjectCreationException objectCreationException) {
                // empty catch block
            }
        }
        return factory;
    }

    public static <T> IFactory<T> lookupFactoryFor(Class<T> clazz) {
        IFactory<T>[] factories = Outlet.get().lookupFactories(clazz);
        if (factories.length > 0) {
            return factories[0];
        }
        String id = clazz.getName() + "Factory";
        IFactory factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            try {
                factory = ObjectTools.createObject(id, IFactory.class, clazz.getClassLoader());
                ObjectTools.initObject(factory);
                Outlet.get().registerFactory(factory.getId(), factory);
                Log.debug("created default factory '" + id + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return factory;
    }

    public static <T> IFactory<T> lookupFactoryFor(Class<T> clazz, List<Tag> tags) {
        IFactory<T>[] factories;
        for (IFactory<T> factory : factories = Outlet.get().lookupFactories(clazz)) {
            if (!TagTools.hasTags(factory, tags)) continue;
            return factory;
        }
        return null;
    }

    public static <T extends IFactory<?>> T lookupFactoryFuzzy(Class<T> clazz) {
        String id = clazz.getName();
        IFactory<Object> factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            String tempId = id + "Factory";
            factory = Outlet.get().lookupFactory(tempId);
            if (factory == null) {
                factory = FactoryTools.basicLookupFactoryFuzzy(clazz);
            }
        }
        return (T)factory;
    }

    public static IFactory<?> lookupFactoryFuzzy(String id, ClassLoader classLoader) {
        IFactory<?> factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            String tempId = id + "Factory";
            factory = Outlet.get().lookupFactory(tempId);
            if (factory == null) {
                try {
                    Class<Object> clazz = ClassTools.createClass(id, Object.class, classLoader);
                    factory = FactoryTools.basicLookupFactoryFuzzy(clazz);
                }
                catch (ObjectCreationException objectCreationException) {
                    // empty catch block
                }
            }
        }
        return factory;
    }

    public static IFactory toFactory(Object value) throws ObjectCreationException {
        Object factory;
        if (value == null) {
            return null;
        }
        if (value instanceof IFactory) {
            return (IFactory)value;
        }
        if (value instanceof String) {
            String name = (String)value;
            if (StringTools.isEmpty(name)) {
                return null;
            }
            IFactory<?> factory2 = FactoryTools.lookupFactoryFuzzy(name, null);
            if (factory2 != null) {
                return factory2;
            }
        }
        if (value instanceof Class && (factory = FactoryTools.lookupFactoryFuzzy((Class)value)) != null) {
            return factory;
        }
        throw new ObjectCreationException("can't create factory from " + StringTools.safeString(value));
    }

    private FactoryTools() {
    }
}

