/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.attachment.Attachment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class FileAttachmentTools {
    private static final Logger Log = LoggerFactory.getLogger(FileAttachmentTools.class);

    protected static String createAttachmentName(String masterName, String movedName, String attachName) {
        String prefix = StringTools.getCommonPrefix(masterName, attachName, true);
        if (StringTools.isEmpty(prefix)) {
            return attachName;
        }
        int masterSuffixLength = masterName.length() - prefix.length();
        int attachSuffixLength = attachName.length() - prefix.length();
        Object newName = movedName;
        newName = ((String)newName).substring(0, ((String)newName).length() - masterSuffixLength);
        newName = (String)newName + attachName.substring(attachName.length() - attachSuffixLength);
        return newName;
    }

    public static List<File> createAttachments(File master, File[] files, String extensions) {
        if (StringTools.isEmpty(extensions)) {
            return Collections.emptyList();
        }
        String masterName = null;
        String masterBaseName = null;
        if (master != null) {
            masterName = master.getName().toLowerCase();
            masterBaseName = PathTools.getBaseName(masterName);
        }
        ArrayList<File> result = new ArrayList<File>();
        String[] tempExtensions = extensions.toLowerCase().split(";");
        block0: for (int j = 0; j < files.length; ++j) {
            File checkFile = files[j];
            String checkFileName = checkFile.getName().toLowerCase();
            if (checkFileName.equals(masterName)) continue;
            String checkFileBaseName = PathTools.getBaseName(checkFileName);
            if (master != null && !checkFileBaseName.equals(masterName) && !checkFileBaseName.equals(masterBaseName)) continue;
            for (int i = 0; i < tempExtensions.length; ++i) {
                String tempExtension = tempExtensions[i].trim();
                boolean required = tempExtension.startsWith("+");
                if (required) {
                    tempExtension = tempExtension.substring(1);
                }
                if (!checkFileName.endsWith(tempExtension)) continue;
                result.add(checkFile);
                continue block0;
            }
        }
        return result;
    }

    public static List<File> createAttachments(File master, String extensions) {
        File tempFile;
        File tempDir;
        if (master.isDirectory()) {
            tempDir = master;
            tempFile = null;
        } else {
            tempDir = master.getParentFile();
            tempFile = master;
        }
        if (tempDir == null) {
            return Collections.emptyList();
        }
        File[] files = tempDir.listFiles();
        return FileAttachmentTools.createAttachments(tempFile, files, extensions);
    }

    public static void deleteAttachments(List<?> attachments) {
        for (Object attachment : attachments) {
            ILocator tempLocator;
            if (attachment instanceof Attachment) {
                attachment = ((Attachment)attachment).getAttached();
            }
            if (attachment instanceof File) {
                if (!((File)attachment).exists() || ((File)attachment).delete()) continue;
                Log.warn("deleting '" + attachment + "' failed");
                continue;
            }
            if (attachment instanceof ILocator) {
                if (!((ILocator)attachment).exists()) continue;
                try {
                    ((ILocator)attachment).delete();
                }
                catch (IOException e) {
                    Log.warn("deleting '" + attachment + "' failed");
                }
                continue;
            }
            if (!(attachment instanceof ILocatorSupport) || !(tempLocator = ((ILocatorSupport)attachment).getLocator()).exists()) continue;
            try {
                tempLocator.delete();
            }
            catch (IOException e) {
                Log.warn("deleting '" + tempLocator + "' failed");
            }
        }
    }

    public static boolean existsAttachments(File master, File[] files, String extensions) {
        if (StringTools.isEmpty(extensions)) {
            return true;
        }
        String masterName = null;
        String masterBaseName = null;
        if (master != null) {
            masterName = master.getName().toLowerCase();
            masterBaseName = PathTools.getBaseName(masterName);
        }
        String[] tempExtensions = extensions.toLowerCase().split(";");
        for (int i = 0; i < tempExtensions.length; ++i) {
            String tempExtension = tempExtensions[i].trim();
            boolean required = tempExtension.startsWith("+");
            if (!required) continue;
            tempExtension = tempExtension.substring(1);
            boolean exists = false;
            for (int j = 0; j < files.length; ++j) {
                File checkFile = files[j];
                String checkFileName = checkFile.getName().toLowerCase();
                String checkFileBaseName = PathTools.getBaseName(checkFileName);
                if (master != null && !checkFileBaseName.equals(masterName) && !checkFileBaseName.equals(masterBaseName) || !checkFileName.endsWith(tempExtension)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            return false;
        }
        return true;
    }

    public static boolean isAttachment(File file, String extensions) {
        if (StringTools.isEmpty(extensions)) {
            return false;
        }
        String fileName = file.getName().toLowerCase();
        String[] tempFilters = extensions.toLowerCase().split(";");
        for (int i = 0; i < tempFilters.length; ++i) {
            String tempFilter = tempFilters[i].trim();
            boolean required = tempFilter.startsWith("+");
            if (required) {
                tempFilter = tempFilter.substring(1);
            }
            if (!fileName.endsWith(tempFilter)) continue;
            return true;
        }
        return false;
    }

    public static File moveAttachment(File master, File attachment, File movedFile, boolean delete) throws IOException {
        File movedDir;
        if (master == null || movedFile == null || attachment == null) {
            return attachment;
        }
        String masterName = master.getName();
        String movedName = movedFile.getName();
        if (movedFile.isDirectory()) {
            movedDir = movedFile;
            movedName = masterName;
        } else {
            movedDir = movedFile.getParentFile();
        }
        if (movedDir == null) {
            return attachment;
        }
        File movedAttachment = FileAttachmentTools.moveAttachment(masterName, attachment, movedName, movedDir, delete);
        return movedAttachment;
    }

    protected static File moveAttachment(String masterName, Object attachment, String movedName, File dir, boolean delete) throws IOException {
        if (attachment instanceof Attachment) {
            attachment = ((Attachment)attachment).getAttached();
        }
        if (attachment instanceof ILocatorSupport) {
            attachment = ((ILocatorSupport)attachment).getLocator();
        }
        if (attachment instanceof FileLocator) {
            attachment = ((FileLocator)attachment).getFile();
        }
        try {
            if (attachment instanceof File) {
                File tempFile = (File)attachment;
                if (tempFile.exists()) {
                    String tempName = tempFile.getName();
                    String newName = FileAttachmentTools.createAttachmentName(masterName, movedName, tempName);
                    File newAttachment = new File(dir, newName);
                    if (newAttachment.equals(tempFile)) {
                        return tempFile;
                    }
                    if (delete) {
                        if (Log.isEnabledForLevel(Level.DEBUG)) {
                            Log.debug("move '{}' to '{}'", (Object)tempFile.getAbsolutePath(), (Object)newAttachment.getAbsolutePath());
                        }
                        FileTools.renameFile(tempFile, newAttachment);
                    } else {
                        if (Log.isEnabledForLevel(Level.DEBUG)) {
                            Log.debug("copy '{}' to '{}'", (Object)tempFile.getAbsolutePath(), (Object)newAttachment.getAbsolutePath());
                        }
                        FileTools.copyFile(tempFile, newAttachment);
                    }
                    return newAttachment;
                }
                Log.debug("attachment '{}' no longer available", (Object)tempFile.getAbsolutePath());
            }
            if (attachment instanceof ILocator) {
                ILocator tempLocator = (ILocator)attachment;
                if (tempLocator.exists()) {
                    String tempName = tempLocator.getName();
                    String newName = FileAttachmentTools.createAttachmentName(masterName, movedName, tempName);
                    File newAttachment = new File(dir, newName);
                    if (Log.isEnabledForLevel(Level.DEBUG)) {
                        Log.debug("create file '{}'", (Object)newAttachment.getAbsolutePath());
                    }
                    LocatorTools.copy(tempLocator, new FileLocator(newAttachment));
                    if (delete) {
                        if (Log.isEnabledForLevel(Level.DEBUG)) {
                            Log.debug("delete locator '{}'", (Object)tempLocator.getPath());
                        }
                        tempLocator.delete();
                    }
                    return newAttachment;
                }
                Log.debug("attachment '{}' no longer available", (Object)tempLocator.getPath());
            }
            return null;
        }
        catch (Exception e) {
            throw new IOException("failed to move attachment '" + attachment + "' attached to '" + masterName + "' (" + e.getMessage() + ")");
        }
    }

    public static List moveAttachments(File master, List attachments, File movedFile, boolean delete) throws IOException {
        if (master == null || movedFile == null || attachments == null || attachments.isEmpty()) {
            return attachments;
        }
        ArrayList<File> result = new ArrayList<File>();
        String masterName = master.getName();
        String movedName = movedFile.getName();
        File movedDir = movedFile.isDirectory() ? movedFile : movedFile.getParentFile();
        if (movedDir == null) {
            return attachments;
        }
        File masterDir = master.isDirectory() ? master : master.getParentFile();
        IOException ex = null;
        for (Object tempAttachment : attachments) {
            Path relativePath;
            Path parent;
            File targetSubdirectory = movedDir;
            if (tempAttachment instanceof File && (parent = (relativePath = masterDir.toPath().relativize(((File)tempAttachment).toPath())).getParent()) != null) {
                targetSubdirectory = new File(targetSubdirectory, parent.toString());
            }
            try {
                File movedAttachment = FileAttachmentTools.moveAttachment(masterName, tempAttachment, movedName, targetSubdirectory, delete);
                if (movedAttachment == null) continue;
                result.add(movedAttachment);
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return result;
    }

    private FileAttachmentTools() {
    }
}

