/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.attachment.Attachment;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.CacheResolver;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.file.CollisionException;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.FilenameResolver;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class FileGroup {
    private static final Logger Log = LoggerFactory.getLogger(FileGroup.class);
    private File master;
    private File root;
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public FileGroup(File master) {
        this.master = master;
    }

    public FileGroup(File root, File master) {
        this.root = root;
        this.master = master;
    }

    protected Attachment copy(Object item, File target) throws IOException {
        Object attached = item;
        if (item instanceof Attachment) {
            attached = ((Attachment)attached).getAttached();
        }
        if (attached instanceof ILocatorSupport) {
            attached = ((ILocatorSupport)attached).getLocator();
        }
        if (attached instanceof FileLocator) {
            attached = ((FileLocator)attached).getFile();
        }
        if (attached instanceof File) {
            return this.copyFile((File)attached, target);
        }
        if (attached instanceof ILocator) {
            return this.copyLocator((ILocator)attached, target);
        }
        return null;
    }

    protected Attachment copyFile(File source, File target) throws IOException {
        if (FileTools.equals(source, target)) {
            return null;
        }
        if (source.exists()) {
            FileTools.copyFile(source, target);
            return new Attachment(target.getName(), target);
        }
        Log.debug("{} item '{}' no longer available", this.getLogId(), (Object)source);
        return null;
    }

    protected Attachment copyLocator(ILocator source, File target) throws IOException {
        if (source.exists()) {
            Log.trace("{} locator copy to '{}'", this.getLogId(), (Object)target.getAbsolutePath());
            InputStream is = null;
            FileOutputStream os = null;
            try {
                is = source.getInputStream();
                os = new FileOutputStream(target);
                StreamTools.copy(is, os);
                if (Log.isEnabledForLevel(Level.TRACE)) {
                    Log.trace("locator move success");
                }
            }
            catch (Exception e) {
                try {
                    Log.debug("{} locator copy failed", this.getLogId());
                    throw new IOException("locator move failed for '" + source.getPath() + "' to '" + target.getAbsolutePath() + "'", e);
                }
                catch (Throwable throwable) {
                    StreamTools.close(is);
                    StreamTools.close(os);
                    throw throwable;
                }
            }
            StreamTools.close(is);
            StreamTools.close(os);
            return new Attachment(target.getName(), target);
        }
        Log.debug("{} item '{}' no longer available", this.getLogId(), (Object)source.getPath());
        return null;
    }

    protected File createTargetFile(File dir, File file, String template, IStringEvaluator resolver) throws IOException {
        String extensionPrefix = FileTools.getExtension(this.master);
        MapResolver filenameResolver = new MapResolver().put("file", new FilenameResolver(file, extensionPrefix));
        TaggedStringEvaluator evaluator = TaggedStringEvaluator.decorate(filenameResolver, resolver);
        String tempName = StringEvaluatorTools.evaluateString(evaluator, template);
        File tempFile = FileTools.resolvePath(dir, tempName = FileTools.trimPath(tempName));
        File parentFile = tempFile.getParentFile();
        if (parentFile != null) {
            FileTools.checkDirectory(parentFile, true, true, true);
        }
        return tempFile;
    }

    protected File createTargetFile(File destination, Object item, String template, IStringEvaluator resolver) throws IOException {
        Object temp = item;
        if (temp instanceof Attachment) {
            temp = ((Attachment)item).getAttached();
        }
        if (temp instanceof ILocatorSupport) {
            temp = ((ILocatorSupport)temp).getLocator();
        }
        if (temp instanceof FileLocator) {
            temp = ((FileLocator)temp).getFile();
        }
        if (temp instanceof File) {
            File tempFile = (File)temp;
            return this.createTargetFile(destination, tempFile, template, resolver);
        }
        if (temp instanceof ILocator) {
            ILocator tempLocator = (ILocator)temp;
            return this.createTargetFile(destination, new File(tempLocator.getPath()), template, resolver);
        }
        return null;
    }

    public void delete() throws IOException {
        this.deleteAll(this.attachments);
        this.delete(this.master);
    }

    protected void delete(Object item) throws IOException {
        Object temp = item;
        if (temp instanceof Attachment) {
            temp = ((Attachment)temp).getAttached();
        }
        if (temp instanceof ILocatorSupport) {
            temp = ((ILocatorSupport)temp).getLocator();
        }
        if (temp instanceof FileLocator) {
            temp = ((FileLocator)temp).getFile();
        }
        if (temp instanceof File) {
            FileTools.delete((File)temp);
        }
        if (temp instanceof ILocator) {
            ILocator tempLocator = (ILocator)temp;
            if (tempLocator.exists()) {
                Log.trace("{} locator delete '{}' ", this.getLogId(), (Object)tempLocator.getPath());
                tempLocator.delete();
            } else {
                Log.debug("{} locator skip '{}'", this.getLogId(), (Object)tempLocator.getPath());
            }
        }
    }

    protected void deleteAll(List<?> deletions) throws IOException {
        for (Object object : deletions) {
            this.delete(object);
        }
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    protected Object getLogId() {
        return "FileGroup " + this.master;
    }

    public File getMaster() {
        return this.master;
    }

    public File getRoot() {
        return this.root;
    }

    public void move(File targetDir, String template, IStringEvaluator resolver, boolean deleteSource, boolean deleteSubdirectories, boolean collisionDetect) throws IOException {
        int i = 3;
        while (--i >= 0) {
            try {
                this.moveRetry(targetDir, template, resolver, deleteSource, deleteSubdirectories, collisionDetect);
                return;
            }
            catch (IOException e) {
                if (i == 0) {
                    throw e;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
                Log.debug("{} retry ('{}')", this.getLogId(), (Object)ExceptionTools.getMessage(e));
            }
        }
    }

    protected void moveRetry(File targetDir, String template, IStringEvaluator resolver, boolean deleteSource, boolean deleteSubdirectories, boolean collisionDetect) throws IOException {
        File targetMaster;
        Log.debug("{} move to '{}'", this.getLogId(), (Object)targetDir);
        CacheResolver cacheResolver = new CacheResolver(resolver);
        FileTools.Lock lock = null;
        ArrayList<Attachment> creations = new ArrayList<Attachment>();
        ArrayList<Attachment> targetAttachments = new ArrayList<Attachment>();
        try {
            Attachment attachment;
            targetMaster = this.createTargetFile(targetDir, this.master, template, (IStringEvaluator)cacheResolver);
            if (FileTools.equals(targetMaster, this.master)) {
                return;
            }
            if (collisionDetect && targetMaster.exists()) {
                throw new CollisionException("'" + targetMaster + "' exists");
            }
            lock = FileTools.lock(targetMaster);
            if (collisionDetect && lock == null) {
                throw new CollisionException("'" + targetMaster + "' locked");
            }
            for (Attachment attachment2 : this.attachments) {
                File attachTarget = this.createTargetFile(targetDir, attachment2, template, (IStringEvaluator)cacheResolver);
                if (!collisionDetect || !attachTarget.exists()) continue;
                throw new CollisionException("'" + attachTarget + "' exists");
            }
            boolean masterReplaced = false;
            for (Attachment attachment3 : this.attachments) {
                File targetAttach = this.createTargetFile(targetDir, attachment3, template, (IStringEvaluator)cacheResolver);
                masterReplaced = masterReplaced || FileTools.equals(targetMaster, targetAttach);
                Attachment copyAttachment = this.copy(attachment3, targetAttach);
                if (copyAttachment != null) {
                    for (Object key : attachment3.getAttributes()) {
                        copyAttachment.setAttribute(key, attachment3.getAttribute(key));
                    }
                    targetAttachments.add(copyAttachment);
                    creations.add(copyAttachment);
                    continue;
                }
                targetAttachments.add(attachment3);
            }
            if (!masterReplaced && (attachment = this.copy(this.master, targetMaster)) != null) {
                creations.add(attachment);
            }
        }
        catch (Exception e) {
            this.deleteAll(creations);
            throw e;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        try {
            if (deleteSource) {
                this.delete();
            }
            if (deleteSubdirectories) {
                FileTools.deleteEmptyDirectories(this.getRoot(), this.master);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.attachments = targetAttachments;
        this.master = targetMaster;
        this.root = targetDir;
    }
}

