/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.string.StringTools;

public final class PathTools {
    public static final char SEPARATOR_ALT_CHAR = '\\';
    public static final String SEPARATOR_STRING = "/";
    public static final char SEPARATOR_CHAR = '/';

    public static String getBaseName(String path) {
        return PathTools.getBaseName(path, null, "");
    }

    public static String getBaseName(String path, String extensionPrefix, String defaultName) {
        int dotPos;
        int pos2;
        if (StringTools.isEmpty(path)) {
            return defaultName;
        }
        int pos1 = path.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = path.lastIndexOf(92));
        if (pos >= 0) {
            path = path.substring(pos + 1);
        }
        if ((dotPos = path.lastIndexOf(46)) >= 1) {
            path = path.substring(0, dotPos);
            if (extensionPrefix != null && path.endsWith("." + extensionPrefix)) {
                path = path.substring(0, path.length() - extensionPrefix.length() - 1);
            }
        }
        return path;
    }

    public static String getExtension(String path) {
        return PathTools.getExtension(path, null, "");
    }

    public static String getExtension(String path, String extensionPrefix, String defaultName) {
        int dotPos;
        int pos2;
        if (StringTools.isEmpty(path)) {
            return defaultName;
        }
        int pos1 = path.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = path.lastIndexOf(92));
        if (pos >= 0) {
            path = path.substring(pos + 1);
        }
        if ((dotPos = path.lastIndexOf(46)) >= 1) {
            Object temp = path.substring(dotPos + 1);
            int extPos = path.lastIndexOf("." + extensionPrefix);
            if (extensionPrefix != null && extPos >= 1 && extPos == dotPos - extensionPrefix.length() - 1) {
                temp = extensionPrefix + "." + (String)temp;
            }
            return temp;
        }
        return defaultName;
    }

    public static String getName(String path) {
        return PathTools.getName(path, "");
    }

    public static String getName(String path, String defaultName) {
        int pos2;
        if (StringTools.isEmpty(path)) {
            return defaultName;
        }
        int pos1 = path.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = path.lastIndexOf(92));
        if (pos >= 0) {
            path = path.substring(pos + 1);
        }
        return path;
    }

    public static String getParent(String path) {
        return PathTools.getParent(path, "");
    }

    public static String getParent(String parent, String defaultName) {
        int pos2;
        if (StringTools.isEmpty(parent)) {
            return defaultName;
        }
        int pos1 = parent.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = parent.lastIndexOf(92));
        if (pos > 0) {
            return parent.substring(0, pos);
        }
        if (pos == 0) {
            return SEPARATOR_STRING;
        }
        return defaultName;
    }

    public static boolean hasLeadingSeparator(String path) {
        return path.startsWith("\\") || path.startsWith(SEPARATOR_STRING);
    }

    public static boolean hasTrailingSeparator(String path) {
        return path.endsWith(SEPARATOR_STRING) || path.endsWith("\\");
    }

    public static boolean isRoot(String path) {
        return path.length() == 1 && (path.endsWith(SEPARATOR_STRING) || path.endsWith("\\"));
    }

    public static String join(String ... segment) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean sbTrailingSeparator = false;
        boolean leadingSeparator = false;
        boolean trailingSeparator = false;
        for (String string : segment) {
            if (string == null || string.length() == 0) continue;
            leadingSeparator = PathTools.hasLeadingSeparator(string);
            trailingSeparator = PathTools.hasTrailingSeparator(string);
            if (sbTrailingSeparator && leadingSeparator) {
                string = PathTools.withoutLeadingSeparator(string);
            }
            if (!(first || sbTrailingSeparator || leadingSeparator)) {
                sb.append(SEPARATOR_STRING);
            }
            sb.append(string);
            first = false;
            sbTrailingSeparator = trailingSeparator;
        }
        return sb.toString();
    }

    public static String toCanonicalSeparator(String path) {
        return path.replace('\\', '/');
    }

    public static String withLeadingSeparator(String path) {
        if (StringTools.isEmpty(path)) {
            return SEPARATOR_STRING;
        }
        if (path.startsWith(SEPARATOR_STRING)) {
            return path;
        }
        return SEPARATOR_STRING + path;
    }

    public static String withoutLastSegment(String path) {
        if (StringTools.isEmpty(path)) {
            return "";
        }
        int index = path.lastIndexOf(SEPARATOR_STRING);
        if (index >= 0) {
            return path.substring(0, index);
        }
        return "";
    }

    public static String withoutLeadingSeparator(String path) {
        if (StringTools.isEmpty(path)) {
            return "";
        }
        while (path.startsWith(SEPARATOR_STRING)) {
            path = path.substring(1);
        }
        return path;
    }

    public static String withoutTrailingSeparator(String path) {
        if (StringTools.isEmpty(path)) {
            return "";
        }
        while (PathTools.hasTrailingSeparator(path)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String withTrailingSeparator(String path) {
        if (StringTools.isEmpty(path)) {
            return "";
        }
        if (PathTools.hasTrailingSeparator(path)) {
            return path;
        }
        if (PathTools.isRoot(path)) {
            return path;
        }
        return path + SEPARATOR_STRING;
    }

    private PathTools() {
    }
}

