/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.function;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.function.Throwing;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class Functions {
    public static <R> Function<Exception, R> logger(Logger log, Supplier<R> defaultValue) {
        return e -> {
            log.warn(e.getMessage(), (Throwable)e);
            return defaultValue.get();
        };
    }

    public static <R> Function<Exception, R> thrower() {
        return e -> {
            throw ExceptionTools.wrap(e);
        };
    }

    public static <T, R> Function<T, R> tryCatch(Throwing.Specific.Function<T, R, Exception> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception e) {
                throw ExceptionTools.wrap(e);
            }
        };
    }

    public static <T, R> Function<T, R> tryCatch(Throwing.Specific.Function<T, R, Exception> function, Function<Exception, R> exceptionHandler) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception e) {
                return exceptionHandler.apply(e);
            }
        };
    }

    public static <T> Supplier<T> tryCatch(Throwing.Specific.Supplier<T, Exception> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                throw ExceptionTools.wrap(e);
            }
        };
    }

    public static <T> Supplier<T> tryCatch(Throwing.Specific.Supplier<T, Exception> supplier, Function<Exception, T> exceptionHandler) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                return exceptionHandler.apply(e);
            }
        };
    }

    public static <T> Consumer<T> tryCatchConsumer(Throwing.Specific.Consumer<T, Exception> consumer) {
        return x -> {
            try {
                consumer.accept(x);
            }
            catch (Exception e) {
                throw ExceptionTools.wrap(e);
            }
        };
    }

    public static <T> Consumer<T> tryCatchConsumer(Throwing.Specific.Consumer<T, Exception> consumer, Function<Exception, T> exceptionHandler) {
        return x -> {
            try {
                consumer.accept(x);
            }
            catch (Exception e) {
                exceptionHandler.apply(e);
            }
        };
    }

    private Functions() {
    }
}

