/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.component.IIdentifiable;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.IFunctorCallFactory;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodExecutionException;
import de.intarsys.tools.reflect.ObjectCreationException;

public class FunctorMethodHandler
implements IMethodHandler,
IAttributeSupport {
    private final IFunctor invoker;
    private final String name;

    public static IMethodHandler create(IFunctor functor) {
        if (functor instanceof IMethodHandler) {
            return (IMethodHandler)((Object)functor);
        }
        if (functor instanceof IIdentifiable) {
            return new FunctorMethodHandler(((IIdentifiable)((Object)functor)).getId(), functor);
        }
        return new FunctorMethodHandler("unknown", functor);
    }

    public FunctorMethodHandler(String name, IFunctor invoker) {
        this.name = name;
        this.invoker = invoker;
    }

    @Override
    public Object getAttribute(Object key) {
        if (this.invoker instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.invoker)).getAttribute(key);
        }
        return null;
    }

    public IFunctor getInvoker() {
        return this.invoker;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object invoke(Object receiver, IArgs args) throws MethodException {
        IFunctorCall call;
        if (this.invoker == null) {
            return null;
        }
        if (receiver instanceof IFunctorCallFactory) {
            try {
                call = ((IFunctorCallFactory)receiver).createFunctorCall(this.invoker, receiver, args);
            }
            catch (ObjectCreationException e) {
                throw new MethodExecutionException(this.getName(), ExceptionTools.unwrap(e));
            }
        } else {
            call = new FunctorCall(receiver, args);
        }
        try {
            return this.invoker.perform(call);
        }
        catch (FunctorException e) {
            throw new MethodExecutionException(this.getName(), ExceptionTools.unwrap(e));
        }
    }

    @Override
    public Object removeAttribute(Object key) {
        if (this.invoker instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.invoker)).removeAttribute(key);
        }
        return null;
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        if (this.invoker instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.invoker)).setAttribute(key, value);
        }
        return null;
    }
}

