/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ipc;

import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.ipc.StandardIPCScope;

public class IPCHandle {
    private static final Object UNDEFINED = new Object();
    private final String id;
    private final StandardIPCScope scope;
    private Object object;

    protected IPCHandle(StandardIPCScope heap, Object object, String id) {
        this.scope = heap;
        this.object = object;
        this.id = id;
    }

    protected IPCHandle(StandardIPCScope heap, String id) {
        this.scope = heap;
        this.object = UNDEFINED;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Object getObject() {
        return this.object;
    }

    protected StandardIPCScope getScope() {
        return this.scope;
    }

    public boolean isResolved() {
        return this.object != UNDEFINED;
    }

    protected void resolve(Object pObject) {
        if (this.object != UNDEFINED) {
            throw new InvalidRequestException("IPC handle is already resolved");
        }
        this.object = pObject;
        this.getScope().resolve(this);
    }

    public String toString() {
        return this.getId();
    }
}

