/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.lang;

import de.intarsys.tools.collection.ArrayTools;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.collection.MapTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.lang.ICopyDeep;
import de.intarsys.tools.string.CharacterTools;
import de.intarsys.tools.string.StringTools;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class LangTools {
    public static Object applyDeep(Object value, Function<IArgs.IBinding, Object> function) {
        return LangTools.applyDeep(value, function, new SingletonBinding(value));
    }

    public static Object applyDeep(Object value, Function<IArgs.IBinding, Object> function, IArgs.IBinding binding) {
        if (value instanceof List) {
            return ListTools.applyDeep((List)value, function);
        }
        if (value instanceof Map) {
            return MapTools.applyDeep((Map)value, function);
        }
        if (value instanceof Object[]) {
            return ArrayTools.applyDeep((Object[])value, function);
        }
        if (value instanceof IArgs) {
            return ArgTools.applyDeep((IArgs)value, function);
        }
        Object mapped = function.apply(binding);
        if (mapped != value) {
            binding.setValue(mapped);
        }
        return mapped;
    }

    public static Object copyDeep(Object object) {
        if (object instanceof List) {
            return ListTools.copyDeep((List)object);
        }
        if (object instanceof Map) {
            return MapTools.copyDeep((Map)object);
        }
        if (object instanceof Object[]) {
            return ArrayTools.copyDeep((Object[])object);
        }
        if (object instanceof IArgs) {
            return ((IArgs)object).copy();
        }
        if (object instanceof ICopyDeep) {
            return ((ICopyDeep)object).copyDeep();
        }
        return object;
    }

    public static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static Object firstNonNull(Object ... values) {
        for (Object value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return StringTools.isEmpty((String)value);
        }
        if (value instanceof char[]) {
            return CharacterTools.isEmpty((char[])value);
        }
        return false;
    }

    private LangTools() {
    }

    public static class SingletonBinding
    implements IArgs.IBinding {
        private Object object;

        public SingletonBinding(Object object) {
            this.object = object;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Object getValue() {
            return this.object;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(Object value) {
            this.object = value;
        }
    }
}

