/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.jul;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.Args;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;

public class FileHandler
extends StreamHandler {
    private static final int MAX_LOCKS = 100;
    private static HashMap<String, String> locks = new HashMap();
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private String lockFileName;
    private FileOutputStream lockStream;
    private File[] files;

    private static native boolean isSetUID();

    public FileHandler() throws IOException, SecurityException {
        this.configure();
        this.openFiles();
    }

    public FileHandler(String pattern) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.openFiles();
    }

    public FileHandler(String pattern, boolean append) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.append = append;
        this.openFiles();
    }

    public FileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.openFiles();
    }

    public FileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.openFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SecurityException {
        super.close();
        if (this.lockFileName == null) {
            return;
        }
        try {
            this.lockStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> hashMap = locks;
        synchronized (hashMap) {
            locks.remove(this.lockFileName);
        }
        new File(this.lockFileName).delete();
        this.lockFileName = null;
        this.lockStream = null;
    }

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this.pattern = this.getStringProperty(cname + ".pattern", "%h/java%u.log");
        try {
            this.pattern = (String)TemplateEvaluator.get(Mode.TRUSTED).evaluate(this.pattern, Args.create());
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        this.limit = this.getIntProperty(cname + ".limit", 0);
        if (this.limit < 0) {
            this.limit = 0;
        }
        this.count = this.getIntProperty(cname + ".count", 1);
        if (this.count <= 0) {
            this.count = 1;
        }
        this.append = this.getBooleanProperty(cname + ".append", false);
        this.setLevel(this.getLevelProperty(cname + ".level", Level.ALL));
        this.setFilter(this.getFilterProperty(cname + ".filter", null));
        this.setFormatter(this.getFormatterProperty(cname + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(this.getStringProperty(cname + ".encoding", null));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private File generate(String pattern, int generation, int unique) throws IOException {
        File file = null;
        Object word = "";
        int ix = 0;
        boolean sawg = false;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File((String)word) : new File(file, (String)word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    if (FileHandler.isSetUID()) {
                        throw new IOException("can't use %h in set UID program");
                    }
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = (String)word + generation;
                    sawg = true;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = (String)word + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = (String)word + "%";
                    ++ix;
                    continue;
                }
            }
            word = (String)word + ch;
        }
        if (this.count > 1 && !sawg) {
            word = (String)word + "." + generation;
        }
        if (unique > 0 && !sawu) {
            word = (String)word + "." + unique;
        }
        if (((String)word).length() > 0) {
            file = file == null ? new File((String)word) : new File(file, (String)word);
        }
        return file;
    }

    protected boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ("true".equals(val = val.toLowerCase()) || "1".equals(val)) {
            return true;
        }
        if ("false".equals(val) || "0".equals(val)) {
            return false;
        }
        return defaultValue;
    }

    protected Filter getFilterProperty(String name, Filter defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    protected Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    protected int getIntProperty(String name, int defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected Level getLevelProperty(String name, Level defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        Level l = Level.parse(val.trim());
        return l != null ? l : defaultValue;
    }

    protected String getStringProperty(String name, String defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, len);
        this.setOutputStream(this.meter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFiles() throws IOException {
        LogManager manager = LogManager.getLogManager();
        if (this.count < 1) {
            throw new IllegalArgumentException("file count = " + this.count);
        }
        if (this.limit < 0) {
            this.limit = 0;
        }
        InitializationErrorManager em = new InitializationErrorManager();
        this.setErrorManager(em);
        int unique = -1;
        while (true) {
            if (++unique > 100) {
                throw new IOException("Couldn't get lock for " + this.pattern);
            }
            this.lockFileName = this.generate(this.pattern, 0, unique).toString() + ".lck";
            HashMap<String, String> hashMap = locks;
            synchronized (hashMap) {
                boolean available;
                FileChannel fc;
                if (locks.get(this.lockFileName) != null) {
                    continue;
                }
                try {
                    this.lockStream = new FileOutputStream(this.lockFileName);
                    fc = this.lockStream.getChannel();
                }
                catch (IOException e) {
                    continue;
                }
                try {
                    available = fc.tryLock() != null;
                }
                catch (IOException e) {
                    available = true;
                }
                if (available) {
                    locks.put(this.lockFileName, this.lockFileName);
                    break;
                }
                fc.close();
            }
        }
        this.files = new File[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.files[i] = this.generate(this.pattern, i, unique);
        }
        if (this.append) {
            this.open(this.files[0], true);
        } else {
            this.rotate();
        }
        Exception ex = em.lastException;
        if (ex != null) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof SecurityException) {
                throw (SecurityException)ex;
            }
            throw new IOException("Exception: " + ex);
        }
        this.setErrorManager(new ErrorManager());
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        if (this.limit > 0 && this.meter.written >= this.limit) {
            this.rotate();
        }
    }

    private synchronized void rotate() {
        Level oldLevel = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        for (int i = this.count - 2; i >= 0; --i) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                f2.delete();
            }
            f1.renameTo(f2);
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException e) {
            this.reportError(null, e, 4);
        }
        this.setLevel(oldLevel);
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }
    }

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
        }

        @Override
        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }
}

