/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.jul;

import de.intarsys.tools.format.TrivialDateFormat;
import de.intarsys.tools.string.StringTools;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.MDC;

public class SimpleFormatter
extends Formatter {
    private static final String LF = StringTools.LS;
    private Format dateFormat = new TrivialDateFormat();
    private int widthSDC = 20;
    private boolean showDate = true;
    private boolean showLevel = true;
    private boolean showName = true;
    private boolean showSDC;
    private boolean showThread = true;
    private int widthLevel = 7;
    private int widthName = 30;
    private int widthThread = 15;

    public static SimpleFormatter parse(String pattern) {
        if (StringTools.isEmpty(pattern)) {
            return null;
        }
        SimpleFormatter formatter = new SimpleFormatter();
        formatter.setShowDate(false);
        formatter.setShowLevel(false);
        formatter.setShowName(false);
        formatter.setShowSDC(false);
        formatter.setShowThread(false);
        int index = 0;
        int len = pattern.length();
        boolean percent = false;
        while (index < len) {
            char c = pattern.charAt(index++);
            if (percent) {
                if (c == '-' || c == '.' || c == '+' || Character.isDigit(c)) continue;
                if (c == 'd') {
                    formatter.setShowDate(true);
                    continue;
                }
                if (c == 'p') {
                    formatter.setShowLevel(true);
                    continue;
                }
                if (c == 'c') {
                    formatter.setShowName(true);
                    continue;
                }
                if (c == 'X') {
                    formatter.setShowSDC(true);
                    continue;
                }
                if (c != 't') continue;
                formatter.setShowThread(true);
                continue;
            }
            if (c != '%') continue;
            percent = true;
        }
        return formatter;
    }

    public SimpleFormatter() {
        this.configure();
    }

    public String asPattern() {
        return null;
    }

    protected void configure() {
        String cname = this.getClass().getName();
        this.setShowSDC(this.getBooleanProperty(cname + ".sdc.show", this.isShowSDC()));
        this.setWidthSDC(this.getIntProperty(cname + ".sdc.width", this.getWidthSDC()));
        this.setShowThread(this.getBooleanProperty(cname + ".thread.show", this.isShowThread()));
        this.setWidthThread(this.getIntProperty(cname + ".thread.width", this.getWidthThread()));
        this.setShowDate(this.getBooleanProperty(cname + ".date.show", this.isShowDate()));
        this.setShowLevel(this.getBooleanProperty(cname + ".level.show", this.isShowLevel()));
        this.setWidthLevel(this.getIntProperty(cname + ".level.width", this.getWidthLevel()));
        this.setShowName(this.getBooleanProperty(cname + ".name.show", this.isShowName()));
        this.setWidthName(this.getIntProperty(cname + ".name.width", this.getWidthName()));
    }

    @Override
    public String format(LogRecord event) {
        return this.format(event, new StringBuffer()).toString();
    }

    public StringBuffer format(Object obj, StringBuffer sb) {
        int i;
        LogRecord event = (LogRecord)obj;
        if (this.isShowDate()) {
            sb.append("[");
            int index = sb.length();
            this.dateFormat.format(new Date(event.getMillis()), sb, null);
            for (i = sb.length() - index; i < 24; ++i) {
                sb.append(' ');
            }
            sb.append("]");
        }
        if (this.isShowLevel()) {
            sb.append("[");
            String levelString = event.getLevel().toString();
            sb.append(levelString);
            for (i = levelString.length(); i < this.widthLevel; ++i) {
                sb.append(' ');
            }
            sb.append("]");
        }
        if (this.isShowName()) {
            String loggerString = event.getLoggerName();
            if (loggerString == null) {
                loggerString = "<unknown>";
            }
            if (loggerString.length() > this.widthName) {
                loggerString = StringTools.getTrailing(loggerString, this.widthName);
            }
            sb.append("[");
            sb.append(loggerString);
            for (i = loggerString.length(); i < this.widthName; ++i) {
                sb.append(' ');
            }
            sb.append("]");
        }
        if (this.isShowThread()) {
            String threadString = Thread.currentThread().getName();
            if (threadString.length() > this.widthThread) {
                threadString = StringTools.getTrailing(threadString, this.widthThread);
            }
            sb.append("[");
            sb.append(threadString);
            for (i = threadString.length(); i < this.widthThread; ++i) {
                sb.append(' ');
            }
            sb.append("]");
        }
        if (this.isShowSDC()) {
            sb.append("[");
            String sdcString = String.valueOf(MDC.get((String)"sdc"));
            sb.append(sdcString);
            for (i = sdcString.length(); i < this.widthSDC; ++i) {
                sb.append(' ');
            }
            sb.append("]");
        }
        sb.append(" ");
        sb.append(this.formatMessage(event));
        sb.append(LF);
        if (event.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                event.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
                sb.append(LF);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb;
    }

    protected boolean getBooleanProperty(String name, boolean defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String property = manager.getProperty(name);
        if (StringTools.isEmpty(property)) {
            return defaultValue;
        }
        return Boolean.valueOf(property.trim());
    }

    protected int getIntProperty(String name, int defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String property = manager.getProperty(name);
        if (StringTools.isEmpty(property)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(property.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getWidthLevel() {
        return this.widthLevel;
    }

    public int getWidthName() {
        return this.widthName;
    }

    public int getWidthSDC() {
        return this.widthSDC;
    }

    public int getWidthThread() {
        return this.widthThread;
    }

    public boolean isShowDate() {
        return this.showDate;
    }

    public boolean isShowLevel() {
        return this.showLevel;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public boolean isShowSDC() {
        return this.showSDC;
    }

    public boolean isShowThread() {
        return this.showThread;
    }

    public void setShowDate(boolean showDate) {
        this.showDate = showDate;
    }

    public void setShowLevel(boolean showLevel) {
        this.showLevel = showLevel;
    }

    public void setShowName(boolean showName) {
        this.showName = showName;
    }

    public void setShowSDC(boolean showSDC) {
        this.showSDC = showSDC;
    }

    public void setShowThread(boolean showThread) {
        this.showThread = showThread;
    }

    public void setWidthLevel(int widthLevel) {
        this.widthLevel = widthLevel;
    }

    public void setWidthName(int widthLoggername) {
        this.widthName = widthLoggername;
    }

    public void setWidthSDC(int widthSDC) {
        this.widthSDC = widthSDC;
    }

    public void setWidthThread(int widthThread) {
        this.widthThread = widthThread;
    }

    static {
        new TrivialDateFormat();
        StringTools.isEmpty("");
        Calendar.getInstance();
    }
}

