/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.nls;

import de.intarsys.tools.nls.INlsContext;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;
import javax.swing.JComponent;

public class StandardNlsContext
implements INlsContext {
    private Deque<Locale> stack = new ArrayDeque<Locale>();
    private Locale current;

    protected void activateLocale(Locale locale) {
        this.stack.push(locale);
        this.current = locale;
        JComponent.setDefaultLocale(locale);
    }

    @Override
    public synchronized Locale getLocale() {
        return this.current == null ? Locale.getDefault() : this.current;
    }

    @Override
    public synchronized boolean isLocalePushed() {
        return !this.stack.isEmpty();
    }

    @Override
    public synchronized void popLocale() {
        this.current = this.stack.pop();
        this.setLocale(this.getLocale());
    }

    @Override
    public synchronized void pushLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        this.activateLocale(locale);
    }

    @Override
    public synchronized void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        this.stack.pollFirst();
        this.activateLocale(locale);
    }
}

