/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.nls;

import de.intarsys.tools.nls.INlsContext;
import de.intarsys.tools.nls.StandardNlsContext;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;

public class ThreadNlsContext
implements INlsContext {
    private INlsContext baseContext = new StandardNlsContext();
    private ThreadLocal<Deque<Locale>> localeHolder = ThreadLocal.withInitial(() -> new ArrayDeque());

    protected void activateLocale(Locale locale) {
    }

    public INlsContext getBaseContext() {
        return this.baseContext;
    }

    @Override
    public Locale getLocale() {
        Deque<Locale> stack = this.localeHolder.get();
        Locale locale = stack.peek();
        if (locale == null) {
            locale = this.baseContext.getLocale();
        }
        return locale;
    }

    @Override
    public boolean isLocalePushed() {
        Deque<Locale> stack = this.localeHolder.get();
        return !stack.isEmpty();
    }

    @Override
    public void popLocale() {
        Deque<Locale> stack = this.localeHolder.get();
        stack.pop();
        Locale locale = stack.peek();
        this.activateLocale(locale);
    }

    @Override
    public void pushLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        Deque<Locale> stack = this.localeHolder.get();
        stack.push(locale);
        this.activateLocale(locale);
    }

    public void setBaseContext(INlsContext baseContext) {
        this.baseContext = baseContext;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        Deque<Locale> stack = this.localeHolder.get();
        stack.pollFirst();
        stack.push(locale);
        this.activateLocale(locale);
    }
}

