/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.converter.NoopConverter;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.FieldNotFoundException;
import de.intarsys.tools.reflect.IBasicAccessSupport;
import de.intarsys.tools.reflect.IBasicInvocationSupport;
import de.intarsys.tools.reflect.IBasicRegistrySupport;
import de.intarsys.tools.reflect.InvocableArgument;
import de.intarsys.tools.reflect.InvocableMethod;
import de.intarsys.tools.reflect.MethodAccessException;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodExecutionException;
import de.intarsys.tools.reflect.MethodInternalException;
import de.intarsys.tools.reflect.MethodNotFoundException;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.string.Token;
import jakarta.annotation.PostConstruct;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectTools {
    public static final Object[] EMPTY_PARAMETERS = new Object[0];
    public static final Class[] EMPTY_PARAMETERTYPES = new Class[0];
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private static final Map<Class, Class> PRIMITIVE_WRAPPER = new HashMap<Class, Class>();
    private static final IConverter DEFAULT_CONVERTER;

    public static Object basicGet(Object object, String name) throws FieldException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        Exception ex = null;
        if (object instanceof IBasicAccessSupport) {
            try {
                return ((IBasicAccessSupport)object).basicGetValue(name);
            }
            catch (FieldNotFoundException e) {
                FieldNotFoundException fieldNotFoundException = ex = ex == null ? e : ex;
            }
        }
        if (object instanceof Map) {
            return ((Map)object).get(name);
        }
        if (object instanceof IArgs) {
            return ((IArgs)object).get(name);
        }
        try {
            Method method = ObjectTools.findGetter(object.getClass(), name);
            return method.invoke(object, (Object[])null);
        }
        catch (Exception e) {
            ex = ex == null ? e : ex;
            try {
                Field field = object.getClass().getField(name);
                return field.get(object);
            }
            catch (Exception e2) {
                ex = ex == null ? e2 : ex;
                try {
                    Method method = object.getClass().getMethod(name, null);
                    return method.invoke(object, (Object[])null);
                }
                catch (Exception e3) {
                    Exception exception = ex = ex == null ? e3 : ex;
                    if (ex instanceof FieldException) {
                        throw (FieldException)ex;
                    }
                    throw new FieldAccessException(object.getClass(), name, (Throwable)ex);
                }
            }
        }
    }

    public static Object basicInsert(Object object, String name, Object value) throws FieldException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        try {
            Method method = ObjectTools.findInserter(ObjectTools.getClass(object), name, value);
            return method.invoke(object, value);
        }
        catch (Exception method) {
            Object tempValue = ObjectTools.get(object, name);
            if (tempValue instanceof Collection) {
                if (((Collection)tempValue).add(value)) {
                    return value;
                }
                return null;
            }
            throw new FieldAccessException(object.getClass(), name, "can't insert in " + name);
        }
    }

    public static Object basicInvoke(Object object, String name, Object ... values) throws MethodException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        if (object instanceof IBasicInvocationSupport) {
            return ((IBasicInvocationSupport)object).basicInvoke(name, values);
        }
        Method method = ObjectTools.findMethod(ObjectTools.getClass(object), name, false, ObjectTools.getClasses(values));
        try {
            return method.invoke(object, values);
        }
        catch (IllegalAccessException e) {
            throw new MethodAccessException(object.getClass(), name, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new MethodInternalException(object.getClass(), name, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MethodExecutionException(object.getClass(), name, e.getCause());
        }
    }

    public static Object basicInvokeArgs(Object object, String name, IArgs args) throws MethodException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        Method method = ObjectTools.findInvocableMethod(ObjectTools.getClass(object), name);
        if (method == null) {
            throw new MethodNotFoundException(ObjectTools.getClass(object), name);
        }
        InvocableArgument[] invocableArguments = ObjectTools.findInvocableMethodInvocableArgumentArray(method);
        Object[] argValues = new Object[invocableArguments.length];
        for (int i = 0; i < argValues.length; ++i) {
            InvocableArgument invocableArgument = invocableArguments[i];
            if (invocableArgument == null) continue;
            String argName = invocableArgument.name();
            Object argValue = ".".equals(argName) ? args : ArgTools.getObject(args, argName, null);
            IConverter converter = DEFAULT_CONVERTER;
            if (!invocableArgument.converter().isAssignableFrom(DEFAULT_CONVERTER.getClass())) {
                try {
                    converter = ObjectTools.createObject(invocableArgument.converter(), IConverter.class);
                }
                catch (ObjectCreationException e) {
                    throw new MethodInternalException(object.getClass(), name, "converter creation failed");
                }
            }
            try {
                argValues[i] = converter.convert(argValue);
                continue;
            }
            catch (ConversionException e) {
                throw new MethodInternalException(object.getClass(), name, "conversion failed");
            }
        }
        try {
            return method.invoke(object, argValues);
        }
        catch (IllegalAccessException e) {
            throw new MethodAccessException(object.getClass(), name, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new MethodInternalException(object.getClass(), name, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MethodExecutionException(object.getClass(), name, e.getCause());
        }
    }

    public static Object basicRemove(Object object, String name, Object value) throws FieldException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        try {
            Method method = ObjectTools.findRemover(ObjectTools.getClass(object), name, value);
            return method.invoke(object, value);
        }
        catch (Exception method) {
            Object tempValue = ObjectTools.get(object, name);
            if (tempValue instanceof Collection) {
                if (((Collection)tempValue).remove(value)) {
                    return value;
                }
                return null;
            }
            throw new FieldAccessException(object.getClass(), name, "can't remove from " + name);
        }
    }

    public static Object basicSet(Object object, String name, Object value) throws FieldException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        if (object instanceof IBasicAccessSupport) {
            return ((IBasicAccessSupport)object).basicSetValue(name, value);
        }
        if (object instanceof Map) {
            return ((Map)object).put(name, value);
        }
        if (object instanceof IArgs) {
            return ((IArgs)object).put(name, value);
        }
        try {
            Method method = ObjectTools.findSetter(ObjectTools.getClass(object), name, value);
            return method.invoke(object, value);
        }
        catch (InvocationTargetException e) {
            throw new FieldAccessException(object.getClass(), name, e.getCause());
        }
        catch (Exception e) {
            try {
                Field field = object.getClass().getField(name);
                Object oldValue = field.get(object);
                field.set(object, value);
                return oldValue;
            }
            catch (Exception e2) {
                throw new FieldAccessException(object.getClass(), name, (Throwable)e2);
            }
        }
    }

    public static Object convert(Object value, String typeName, ClassLoader classLoader) throws ObjectCreationException {
        if (typeName == null) {
            return value;
        }
        Class<Object> type = ClassTools.createClass(typeName, Object.class, classLoader);
        try {
            return ConverterRegistry.get().convert(value, type);
        }
        catch (ConversionException e) {
            throw new ObjectCreationException(e);
        }
    }

    public static String createId(Object object) {
        return Integer.toHexString(System.identityHashCode(object));
    }

    public static String createLabel(Object object) {
        return ObjectTools.createLabel(object, ObjectTools.createId(object));
    }

    public static String createLabel(Object object, Object id) {
        return ClassTools.getUnqualifiedName(object.getClass()) + "@" + id;
    }

    public static <T> T createObject(Class clazz, Class<T> expectedClass) throws ObjectCreationException {
        return ObjectTools.createObject(clazz, expectedClass, EMPTY_PARAMETERTYPES, EMPTY_PARAMETERS);
    }

    public static <T> T createObject(Class clazz, Class<T> expectedClass, Class[] parameterTypes, Object[] parameters) throws ObjectCreationException {
        if (clazz == null) {
            throw new ObjectCreationException("class missing");
        }
        Object object = null;
        Throwable ex = null;
        try {
            Method method = clazz.getDeclaredMethod("create", parameterTypes);
            object = method.invoke(null, parameters);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor constructor = clazz.getConstructor(parameterTypes);
                object = constructor.newInstance(parameters);
            }
            catch (Throwable inner) {
                ex = inner;
            }
        }
        catch (Throwable e) {
            ex = e;
        }
        if (ex != null) {
            String message = "class '" + clazz.getName() + "' can't be instantiated";
            throw ExceptionTools.unwrapTyped(ex, ObjectCreationException.class, message);
        }
        if (object instanceof IInitializeable) {
            ((IInitializeable)object).initializeAfterCreation();
        }
        return (T)object;
    }

    public static <T> T createObject(Class<T> clazz) throws ObjectCreationException {
        return ObjectTools.createObject(clazz, clazz, EMPTY_PARAMETERTYPES, EMPTY_PARAMETERS);
    }

    public static <T> T createObject(String className, Class<T> expectedClass, ClassLoader classLoader) throws ObjectCreationException {
        Class<T> clazz = ClassTools.createClass(className, expectedClass, classLoader);
        return ObjectTools.createObject(clazz, expectedClass);
    }

    public static Method findGetter(Class clazz, String name) throws MethodException {
        try {
            String methodName = GET_PREFIX + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            return clazz.getMethod(methodName, null);
        }
        catch (Exception methodName) {
            String methodName2 = IS_PREFIX + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            try {
                return clazz.getMethod(methodName2, null);
            }
            catch (Exception e) {
                throw new MethodNotFoundException(clazz, name);
            }
        }
    }

    public static Method findInserter(Class clazz, String attribute, Object value) throws MethodException {
        Method result;
        try {
            String methodName = "add" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
            result = ObjectTools.findMethod(clazz, methodName, false, ObjectTools.getClass(value));
        }
        catch (Exception e) {
            try {
                String methodName = "insert" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
                result = ObjectTools.findMethod(clazz, methodName, false, ObjectTools.getClass(value));
            }
            catch (Exception nested) {
                String methodName = "register" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
                result = ObjectTools.findMethod(clazz, methodName, false, ObjectTools.getClass(value));
            }
        }
        return result;
    }

    protected static Method findInvocableMethod(Class clazz, String name) {
        Class<?>[] ifaces;
        Method method;
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            InvocableMethod annot;
            method = methods[i];
            if (!method.getName().equals(name) || (annot = method.getAnnotation(InvocableMethod.class)) == null) continue;
            return method;
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class && (method = ObjectTools.findInvocableMethod(clazz.getSuperclass(), name)) != null) {
            return method;
        }
        for (Class<?> iface : ifaces = clazz.getInterfaces()) {
            method = ObjectTools.findInvocableMethod(iface, name);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    protected static InvocableArgument[] findInvocableMethodInvocableArgumentArray(Method method) {
        Annotation[][] allAnnots = method.getParameterAnnotations();
        InvocableArgument[] result = new InvocableArgument[allAnnots.length];
        int i = 0;
        Annotation[][] annotationArray = allAnnots;
        int n = annotationArray.length;
        for (int j = 0; j < n; ++j) {
            Annotation[] paramAnnots;
            for (Annotation paramAnnot : paramAnnots = annotationArray[j]) {
                if (paramAnnot.annotationType() != InvocableArgument.class) continue;
                result[i] = (InvocableArgument)paramAnnot;
            }
            ++i;
        }
        return result;
    }

    public static Method findMethod(Class clazz, String name, boolean wildcard, Class ... classes) throws MethodNotFoundException {
        if (classes != null) {
            try {
                return clazz.getMethod(name, classes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!wildcard ? !method.getName().equals(name) : !method.getName().startsWith(name)) continue;
            if (classes == null) {
                return method;
            }
            Class[] parameterTypes = method.getParameterTypes();
            if (classes.length != parameterTypes.length || !ObjectTools.isAssignable(classes, parameterTypes)) continue;
            return method;
        }
        throw new MethodNotFoundException(clazz, name);
    }

    public static Method findMethodPrefixed(Class clazz, String methodPrefix, Object ... parameters) throws MethodException {
        Class[] parameterClasses = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterClasses[i] = parameters[i].getClass();
        }
        Method method = null;
        method = ObjectTools.findMethod(clazz, methodPrefix, true, parameterClasses);
        return method;
    }

    public static Method findRegister(Class clazz, Object value) throws MethodException {
        String methodPrefix = "register";
        return ObjectTools.findMethodPrefixed(clazz, methodPrefix, value);
    }

    public static Method findRemover(Class clazz, String attribute, Object value) throws MethodException {
        String methodName = "remove" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
        return ObjectTools.findMethod(clazz, methodName, false, ObjectTools.getClass(value));
    }

    public static Method findSetter(Class clazz, String attribute, Object value) throws MethodException {
        String methodName = "set" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
        return ObjectTools.findMethod(clazz, methodName, false, ObjectTools.getClass(value));
    }

    public static Object get(Object object, String name) throws FieldException {
        List<Token> tokens = StringTools.pathParse(name, '.');
        Object current = object;
        for (Token token : tokens) {
            current = ObjectTools.basicGet(current, token.getValue());
        }
        return current;
    }

    protected static Class getClass(Object value) {
        return value == null ? Any.class : value.getClass();
    }

    protected static Class[] getClasses(Object ... parameters) {
        Class[] parameterClasses = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterClasses[i] = ObjectTools.getClass(parameters[i]);
        }
        return parameterClasses;
    }

    public static void initObject(Object object) throws ObjectCreationException {
        if (object == null) {
            return;
        }
        if (object instanceof IInitializeable) {
            ((IInitializeable)object).initializeAfterConstruction();
        }
        try {
            ObjectTools.invokeMethodAnnotatedWith(object, PostConstruct.class);
        }
        catch (MethodException e) {
            throw ExceptionTools.unwrapTyped(e, ObjectCreationException.class);
        }
    }

    public static Object insert(Object object, String name, Object value) throws FieldException {
        List<Token> tokens = StringTools.pathParse(name, '.');
        Object current = object;
        Iterator<Token> itTokens = tokens.iterator();
        Token token = itTokens.next();
        while (itTokens.hasNext()) {
            current = ObjectTools.basicGet(current, token.getValue());
            token = itTokens.next();
        }
        return ObjectTools.basicInsert(current, name, value);
    }

    public static Object invoke(Object object, String name, Object ... values) throws MethodException {
        List<Token> tokens = StringTools.pathParse(name, '.');
        Object current = object;
        Iterator<Token> itTokens = tokens.iterator();
        Token token = itTokens.next();
        while (itTokens.hasNext()) {
            try {
                current = ObjectTools.basicGet(current, token.getValue());
            }
            catch (FieldException e) {
                throw new MethodExecutionException(object.getClass(), name, (Throwable)e);
            }
            token = itTokens.next();
        }
        return ObjectTools.basicInvoke(current, name, values);
    }

    public static Object invokeArgs(Object object, String name, IArgs args) throws MethodException {
        List<Token> tokens = StringTools.pathParse(name, '.');
        Object current = object;
        Iterator<Token> itTokens = tokens.iterator();
        Token token = itTokens.next();
        while (itTokens.hasNext()) {
            try {
                current = ObjectTools.basicGet(current, token.getValue());
            }
            catch (FieldException e) {
                throw new MethodExecutionException(object.getClass(), name, (Throwable)e);
            }
            token = itTokens.next();
        }
        return ObjectTools.basicInvokeArgs(current, token.getValue(), args);
    }

    public static Object invokeMethodAnnotatedWith(Object object, Class annotation) throws MethodException {
        Class<?> clazz = object.getClass();
        Method[] methods = clazz.getMethods();
        Object result = null;
        for (int index = methods.length - 1; index >= 0; --index) {
            Method method = methods[index];
            if (method.getAnnotation(annotation) == null) continue;
            try {
                result = method.invoke(object, new Object[0]);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new MethodAccessException(object.getClass(), method.getName(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new MethodInternalException(object.getClass(), method.getName(), e.getCause());
            }
            catch (InvocationTargetException e) {
                throw new MethodExecutionException(object.getClass(), method.getName(), e.getCause());
            }
        }
        return result;
    }

    public static boolean isAssignable(Class target, Class source) {
        if (source == Any.class) {
            return true;
        }
        if (target.isAssignableFrom(source)) {
            return true;
        }
        if (target.isPrimitive()) {
            return PRIMITIVE_WRAPPER.get(target).isAssignableFrom(source);
        }
        if (source.isPrimitive()) {
            return target.isAssignableFrom(PRIMITIVE_WRAPPER.get(source));
        }
        return false;
    }

    private static boolean isAssignable(Class[] classes, Class[] parameterTypes) {
        for (int j = 0; j < parameterTypes.length; ++j) {
            Class parameterType = parameterTypes[j];
            Class searchType = classes[j];
            if (ObjectTools.isAssignable(parameterType, searchType)) continue;
            return false;
        }
        return true;
    }

    public static Object register(Object registry, Object value) throws MethodException {
        if (registry instanceof IBasicRegistrySupport) {
            return ((IBasicRegistrySupport)registry).basicRegister(value);
        }
        Method method = ObjectTools.findRegister(ObjectTools.getClass(registry), value);
        try {
            return method.invoke(registry, value);
        }
        catch (Exception e) {
            throw new MethodExecutionException(registry.getClass(), "register", ExceptionTools.unwrap(e));
        }
    }

    public static Object remove(Object object, String name, Object value) throws FieldException {
        List<Token> tokens = StringTools.pathParse(name, '.');
        Object current = object;
        Iterator<Token> itTokens = tokens.iterator();
        Token token = itTokens.next();
        while (itTokens.hasNext()) {
            current = ObjectTools.basicGet(current, token.getValue());
            token = itTokens.next();
        }
        return ObjectTools.basicRemove(current, name, value);
    }

    public static Object set(Object object, String name, Object value) throws FieldException {
        List<Token> tokens = StringTools.pathParse(name, '.');
        Object current = object;
        Iterator<Token> itTokens = tokens.iterator();
        Token token = itTokens.next();
        while (itTokens.hasNext()) {
            current = ObjectTools.basicGet(current, token.getValue());
            token = itTokens.next();
        }
        return ObjectTools.basicSet(current, token.getValue(), value);
    }

    public static void setProperties(Object object, IArgs initProperties) throws FieldException, ObjectCreationException, FunctorException {
        Iterator<IArgs.IBinding> it = initProperties.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            ObjectTools.setProperty(object, binding);
        }
    }

    public static void setProperty(Object object, IArgs.IBinding binding) throws FieldException, ObjectCreationException, FunctorException {
        String property = binding.getName();
        Object value = binding.getValue();
        ObjectTools.set(object, property, value);
    }

    static {
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("bool", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("void", Void.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER.put(Void.TYPE, Void.class);
        PRIMITIVE_WRAPPER.put(Short.TYPE, Short.class);
        DEFAULT_CONVERTER = new NoopConverter();
    }

    class Any {
        Any() {
        }
    }
}

