/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui.toolkit;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IActivityHandler;
import de.intarsys.tools.activity.IActivityView;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.ui.toolkit.IToolkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonToolkit
implements IToolkit,
IActivityHandler {
    private static final Logger Log = LoggerFactory.getLogger(CommonToolkit.class);
    private boolean silent;

    protected CommonToolkit() {
    }

    @Override
    public <R> IActivityView activityEnter(IActivity<R> activity) {
        Class<IActivityHandler> expectedClass;
        Class<?> clazz = activity.getClass();
        IActivityHandler toolkitObject = this.createToolkitObject(clazz, expectedClass = IActivityHandler.class, "Handler");
        if (toolkitObject != null) {
            IActivityHandler handler = toolkitObject;
            return handler.activityEnter(activity);
        }
        Log.debug("no toolkit object found for {}", activity);
        return null;
    }

    protected <T> Class<T> createToolkitClass(ClassLoader classLoader, Class<T> expectedType, String packageName, String id, String unqualifiedName, String suffix) {
        if (id == null) {
            return null;
        }
        id = id.toLowerCase();
        String className = packageName + "." + id + "." + unqualifiedName + suffix;
        try {
            return ClassTools.createClass(className, expectedType, classLoader);
        }
        catch (ObjectCreationException objectCreationException) {
            return null;
        }
    }

    @Override
    public <T> T createToolkitObject(Class<?> clazz, Class<T> expectedType, String suffix) {
        Class<T> toolkitClass = null;
        T toolkitObject = null;
        String className = clazz.getName();
        String packageName = ClassTools.getPackageName(className);
        String unqualifiedName = ClassTools.getUnqualifiedName(className);
        if (clazz.isInterface() && unqualifiedName.startsWith("I")) {
            unqualifiedName = unqualifiedName.substring(1);
        }
        String string = suffix = suffix == null ? "" : suffix;
        if (this.isUseSilentHandler()) {
            toolkitClass = this.createToolkitClass(null, expectedType, packageName, "silent", unqualifiedName, suffix);
        }
        if (toolkitClass == null) {
            toolkitClass = this.createToolkitClass(null, expectedType, packageName, this.getToolkitID(), unqualifiedName, suffix);
        }
        if (toolkitClass == null) {
            toolkitClass = this.createToolkitClass(null, expectedType, packageName, this.getToolkitIDFallback(), unqualifiedName, suffix);
        }
        if (toolkitClass != null) {
            try {
                toolkitObject = ObjectTools.createObject(toolkitClass, expectedType);
                ObjectTools.initObject(toolkitObject);
            }
            catch (ObjectCreationException objectCreationException) {
                // empty catch block
            }
        }
        return toolkitObject;
    }

    protected String getToolkitID() {
        return "UI";
    }

    protected String getToolkitIDFallback() {
        return "UI";
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    protected boolean isUseSilentHandler() {
        return this.isSilent();
    }

    @Override
    public boolean setSilent(boolean silent) {
        boolean oldValue = this.silent;
        this.silent = silent;
        return oldValue;
    }
}

