/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.zones;

import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.concurrent.ForwardedThreadLocal;
import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.StandardZone;
import java.util.ArrayDeque;
import java.util.Deque;

@Singleton
public final class Zone {
    private static final ThreadLocal<Deque<IZone>> CURRENT = new ForwardedThreadLocal(){

        @Override
        protected Object initialValue() {
            return new ArrayDeque();
        }
    };
    private static final StandardZone ROOT_ZONE = new StandardZone("root", null);

    public static IZone getCurrent() {
        Deque<IZone> zones = CURRENT.get();
        IZone temp = zones.peek();
        if (temp == null) {
            temp = ROOT_ZONE;
        }
        return temp;
    }

    public static IZone getRoot() {
        return ROOT_ZONE;
    }

    static IZone peek() {
        return CURRENT.get().peek();
    }

    protected static void pop() {
        Deque<IZone> stack = CURRENT.get();
        stack.pop();
        if (stack.isEmpty()) {
            CURRENT.remove();
        }
    }

    static void push(IZone zone) {
        CURRENT.get().push(zone);
    }

    private Zone() {
    }
}

