/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.encryption;

import de.intarsys.document.model.IDocument;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.crypt.StandardSecurityHandlerR2;
import de.intarsys.pdf.crypt.StandardSecurityHandlerR3;
import de.intarsys.pdf.crypt.StandardSecurityHandlerR4;
import de.intarsys.pdf.crypt.SystemSecurityHandler;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.security.processor.encryption.IDocumentEncryptor;
import de.intarsys.tools.factory.IFactory;

public class PDFDocumentEncryptor
extends CommonDocumentProcessor
implements IDocumentEncryptor {
    public static final String ARG_PERMISSIONS = "permissions";
    public static final String ARG_OWNERPASSWORD = "ownerPassword";
    public static final String ARG_USERPASSWORD = "userPassword";
    public static final String ARG_REVISION = "revision";
    public static final String ARG_ENCRYPT_METADATA = "metadata";
    private int permissions;
    private String userPassword;
    private String ownerPassword;
    private int revision;
    private boolean encryptMetadata;

    public PDFDocumentEncryptor(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected void basicRun() throws Exception {
        StandardSecurityHandlerR2 securityHandler;
        SystemSecurityHandler systemSecurityHandler;
        STDocument stDoc = this.getPDDoc().cosGetDoc().stGetDoc();
        boolean tmpEncryptMetadata = false;
        switch (this.getRevision()) {
            case 2: {
                systemSecurityHandler = SystemSecurityHandler.createNewV1();
                securityHandler = new StandardSecurityHandlerR2();
                break;
            }
            case 3: {
                systemSecurityHandler = SystemSecurityHandler.createNewV2();
                securityHandler = new StandardSecurityHandlerR3();
                break;
            }
            case 4: {
                systemSecurityHandler = SystemSecurityHandler.createNewV4();
                securityHandler = new StandardSecurityHandlerR4();
                tmpEncryptMetadata = this.isEncryptMetadata();
                break;
            }
            default: {
                throw new COSSecurityException("unsupported revision " + this.revision);
            }
        }
        systemSecurityHandler.setSecurityHandler((ISecurityHandler)securityHandler);
        stDoc.setSystemSecurityHandler((ISystemSecurityHandler)systemSecurityHandler);
        securityHandler.setEncryptMetadata(tmpEncryptMetadata);
        if (this.getOwnerPassword() != null) {
            securityHandler.setOwnerPassword(this.getOwnerPassword().getBytes());
        }
        if (this.getUserPassword() != null) {
            securityHandler.setUserPassword(this.getUserPassword().getBytes());
        }
        securityHandler.basicSetPermissionFlags(this.getPermissions());
        securityHandler.apply();
        this.ok();
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    protected PDDocument getPDDoc() {
        PDDocument doc = (PDDocument)this.getDocument().getImpl();
        return doc;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public boolean isEncryptMetadata() {
        return this.encryptMetadata;
    }

    public void setEncryptMetadata(boolean encryptMetadata) {
        this.encryptMetadata = encryptMetadata;
    }

    public void setOwnerPassword(String ownerPassword) {
        this.ownerPassword = ownerPassword;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }
}

