/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.signature;

import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.document.type.pdf.signature.ISignatureDecorator;
import de.intarsys.security.document.type.pdf.signature.PDFDocumentSigner;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfoSet;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.factory.CommonObject;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;

public abstract class CommonSignatureDecorator
extends CommonObject
implements ISignatureDecorator {
    public static final String ARG_MINHEIGHT = "minHeight";
    public static final String ARG_TEXT = "text";
    private PDFDocumentSigner documentSigner;

    public static int getMinHeight(IArgs args) {
        return ArgTools.getInt((IArgs)args, (String)ARG_MINHEIGHT, (int)0);
    }

    public static String getText(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)ARG_TEXT, null);
    }

    protected abstract IAppearanceCreator createAppearanceCreator();

    protected IAdditionalInfoSet getAdditionalInfoSet() {
        return this.getDocumentSigner().getAdditionalInfoSetExpanded();
    }

    @Override
    public IAppearanceCreator getAppearanceCreator() {
        return this.createAppearanceCreator();
    }

    protected ISigner getDigestSigner() {
        return this.getDocumentSigner().getDigestSigner();
    }

    public PDFDocumentSigner getDocumentSigner() {
        return this.documentSigner;
    }

    protected IStringEvaluator getTemplateEvaluator() {
        return this.getDocumentSigner().getTemplateEvaluator();
    }

    protected String getText() {
        String template = CommonSignatureDecorator.getText(this.getArgs());
        if (StringTools.isEmpty((String)template)) {
            template = this.getDocumentSigner().getSignatureLabel();
        }
        if (StringTools.isEmpty((String)template)) {
            return "";
        }
        return StringEvaluatorTools.evaluateString((IStringEvaluator)this.getTemplateEvaluator(), (String)template);
    }

    protected boolean isEmbedFonts() {
        return ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)"embedFonts", (boolean)this.getDocumentSigner().isEmbedFonts());
    }

    @Override
    public void setDocumentSigner(PDFDocumentSigner documentSigner) {
        this.documentSigner = documentSigner;
    }
}

