/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.signature;

import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.design.shape.Group;
import de.intarsys.pdf.design.shape.None;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.design.shape.ShapeAppearanceCreator;
import de.intarsys.pdf.design.shape.Text;
import de.intarsys.pdf.signature.appearance.CertificateText;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.info.IPublicKeyInfo;
import de.intarsys.security.certificate.info.X509PublicKeyInfo;
import de.intarsys.security.document.type.pdf.signature.CommonSignatureDecorator;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgsBuilder;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;

public class DefaultDecorator
extends CommonSignatureDecorator {
    public static final String ARG_RENDER_SIGNERNAME = "renderSignername";
    public static final String ARG_RENDER_SIGNER = "renderSigner";
    public static final String ARG_RENDER_ISSUER = "renderIssuer";
    public static final String ARG_RENDER_DATE = "renderDate";
    private boolean renderSignerName = true;
    private boolean renderSigner = true;
    private boolean renderIssuer = true;
    private boolean renderDate = true;

    @Override
    protected IAppearanceCreator createAppearanceCreator() {
        Object textShape;
        String text = this.getText();
        if (StringTools.isEmpty((String)text)) {
            IX509PublicKeyCertificate certificate;
            IX509PublicKeyCertificate[] certs = this.getDigestSigner().getCertificatePath();
            IX509PublicKeyCertificate iX509PublicKeyCertificate = certificate = certs == null || certs.length == 0 ? null : certs[0];
            textShape = certificate == null ? None.create((IArgs)Args.create()) : this.createCertificateShape(certificate);
        } else {
            textShape = this.createSimpleShape(text);
        }
        ShapeAppearanceCreator appearanceCreator = new ShapeAppearanceCreator();
        Group group = Group.create((IArgs)Args.createNamed((Object[])new Object[]{"shapes", List.of(textShape)}));
        appearanceCreator.setShape(group);
        appearanceCreator.setEmbedFonts(this.isEmbedFonts());
        return appearanceCreator;
    }

    protected Shape createCertificateShape(IX509PublicKeyCertificate certificate) {
        IArgs textShapeArgs = new ArgsBuilder().put("size", (Object)"100%x100%").put("align", (Object)"start;end").build();
        LocalDateTime now = LocalDateTime.ofInstant(DateEnvironment.get().now().toInstant(), ZoneId.systemDefault());
        CertificateText textShape = new CertificateText((IPublicKeyInfo)new X509PublicKeyInfo(certificate), now, textShapeArgs);
        textShape.setIncludeDate(this.isRenderDate());
        textShape.setIncludeKeyInfoIssuer(this.isRenderIssuer());
        textShape.setIncludeKeyInfoSubject(this.isRenderSigner());
        textShape.setIncludeSignerName(this.isRenderSignerName());
        return textShape;
    }

    protected Shape createSimpleShape(String text) {
        IArgs textShapeArgs = new ArgsBuilder().put("text", (Object)text).put("size", (Object)"100%x100%").put("align", (Object)"start;end;shrink").build();
        Text textShape = Text.create((IArgs)textShapeArgs);
        textShape.setText(text);
        return textShape;
    }

    public boolean isRenderDate() {
        return this.renderDate;
    }

    public boolean isRenderIssuer() {
        return this.renderIssuer;
    }

    public boolean isRenderSigner() {
        return this.renderSigner;
    }

    public boolean isRenderSignerName() {
        return this.renderSignerName;
    }

    public void setRenderDate(boolean renderDate) {
        this.renderDate = renderDate;
    }

    public void setRenderIssuer(boolean renderIssuer) {
        this.renderIssuer = renderIssuer;
    }

    public void setRenderSigner(boolean renderSigner) {
        this.renderSigner = renderSigner;
    }

    public void setRenderSignerName(boolean renderSignerName) {
        this.renderSignerName = renderSignerName;
    }
}

