/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.signature;

import de.intarsys.pdf.design.shape.Group;
import de.intarsys.pdf.design.shape.IDrawContext;
import de.intarsys.pdf.design.shape.Image;
import de.intarsys.pdf.design.shape.None;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.design.shape.Text;
import de.intarsys.tools.enumeration.common.EnumBlockLayout;
import de.intarsys.tools.enumeration.common.IResize;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.geometry.Dimension2D_Double;
import de.intarsys.tools.geometry.PointSpec;
import de.intarsys.tools.locator.ILocator;
import java.awt.geom.Dimension2D;

public class ExtendedAppearanceGroup
extends Group {
    private static final double SPACING = 5.0;
    private EnumBlockLayout layout = EnumBlockLayout.OVERLAY;
    private Shape potentialGraphics;
    private Shape potentialText;

    public static ExtendedAppearanceGroup create(IArgs args) {
        ExtendedAppearanceGroup shape = new ExtendedAppearanceGroup();
        shape.init(args);
        return shape;
    }

    private static double getMaxHeight(Shape shape, IDrawContext drawContext, double width) {
        Dimension2D_Double maxContainerSize = new Dimension2D_Double(width, 2.147483647E9);
        shape.layout(drawContext, (Dimension2D)maxContainerSize);
        return shape.getSize().getHeight();
    }

    private static double getMaxWidth(Shape shape, IDrawContext drawContext, double height) {
        Dimension2D_Double maxContainerSize = new Dimension2D_Double(2.147483647E9, height);
        shape.layout(drawContext, (Dimension2D)maxContainerSize);
        return shape.getSize().getWidth();
    }

    private static double getMinHeight(Shape shape, IDrawContext drawContext) {
        Dimension2D_Double minContainerSize = new Dimension2D_Double();
        shape.layout(drawContext, (Dimension2D)minContainerSize);
        return shape.getSize().getHeight();
    }

    private static double getMinWidth(Shape shape, IDrawContext drawContext) {
        Dimension2D_Double minContainerSize = new Dimension2D_Double();
        shape.layout(drawContext, (Dimension2D)minContainerSize);
        return shape.getSize().getWidth();
    }

    private static RectAlignment tweakAlignment(Shape shape) {
        RectAlignment previousAlignment = shape.getAlignment();
        RectAlignment newAlignment = new RectAlignment();
        newAlignment.setHorizontalAlignment(previousAlignment.getHorizontalAlignment());
        newAlignment.setHorizontalResize((IResize)new ExtendedResize(previousAlignment.getHorizontalResize()));
        newAlignment.setProportional(previousAlignment.isProportional());
        newAlignment.setVerticalAlignment(previousAlignment.getVerticalAlignment());
        newAlignment.setVerticalResize((IResize)new ExtendedResize(previousAlignment.getVerticalResize()));
        shape.setAlignment(newAlignment);
        return previousAlignment;
    }

    protected ExtendedAppearanceGroup() {
    }

    protected double[] allocateSpace(double min1, double max1, double min2, double max2, double totalAvailable) {
        if (totalAvailable == 0.0) {
            return new double[]{0.0, 0.0};
        }
        double available = totalAvailable - 5.0;
        if (max1 == 0.0 || min1 == 0.0 && min2 >= available) {
            return new double[]{0.0, totalAvailable};
        }
        if (max2 == 0.0 || min2 == 0.0 && min1 >= available) {
            return new double[]{totalAvailable, 0.0};
        }
        if (available <= 0.0) {
            return new double[]{0.0, 0.0};
        }
        double totalMax = max1 + max2;
        if (totalMax == 0.0) {
            return new double[]{available / 2.0, available / 2.0};
        }
        if (totalMax <= available) {
            return new double[]{max1 * available / totalMax, max2 * available / totalMax};
        }
        double totalMin = min1 + min2;
        if (totalMin >= available) {
            return new double[]{min1 * available / totalMin, min2 * available / totalMin};
        }
        double remaining = available - totalMin;
        double range1 = max1 - min1;
        double range2 = max2 - min2;
        double totalRange = range1 + range2;
        if (totalRange == 0.0) {
            return new double[]{min1 * available / totalMin, min2 * available / totalMin};
        }
        return new double[]{min1 + range1 * remaining / totalRange, min2 + range2 * remaining / totalRange};
    }

    protected void init(IArgs args) {
        if (args.get("shapes") != null) {
            throw new IllegalArgumentException("can't handle extra shapes");
        }
        super.init(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layout(IDrawContext drawContext, Dimension2D containerSize) {
        RectAlignment previousAlignmentGraphics = ExtendedAppearanceGroup.tweakAlignment(this.potentialGraphics);
        RectAlignment previousAlignmentText = ExtendedAppearanceGroup.tweakAlignment(this.potentialText);
        try {
            if (this.layout.isHorizontal()) {
                if (this.layout == EnumBlockLayout.TEXT_LEFT_OF_ICON) {
                    this.layoutHorizontal(this.potentialText, this.potentialGraphics, drawContext, containerSize);
                } else {
                    this.layoutHorizontal(this.potentialGraphics, this.potentialText, drawContext, containerSize);
                }
            } else if (this.layout.isVertical()) {
                if (this.layout == EnumBlockLayout.TEXT_ABOVE_ICON) {
                    this.layoutVertical(this.potentialText, this.potentialGraphics, drawContext, containerSize);
                } else {
                    this.layoutVertical(this.potentialGraphics, this.potentialText, drawContext, containerSize);
                }
            }
        }
        finally {
            this.potentialGraphics.setAlignment(previousAlignmentGraphics);
            this.potentialText.setAlignment(previousAlignmentText);
        }
        this.getShapes().clear();
        this.addShape(this.potentialGraphics);
        this.addShape(this.potentialText);
        super.layout(drawContext, containerSize);
    }

    protected void layoutHorizontal(Shape left, Shape right, IDrawContext drawContext, Dimension2D containerSize) {
        double containerWidth = containerSize.getWidth();
        double commonHeight = containerSize.getHeight();
        double leftMin = ExtendedAppearanceGroup.getMinWidth(left, drawContext);
        double rightMin = ExtendedAppearanceGroup.getMinWidth(right, drawContext);
        double leftMax = ExtendedAppearanceGroup.getMaxWidth(left, drawContext, commonHeight);
        double rightMax = ExtendedAppearanceGroup.getMaxWidth(right, drawContext, commonHeight);
        double[] leftRight = this.allocateSpace(leftMin, leftMax, rightMin, rightMax, containerWidth);
        left.setSizeSpec(PointSpec.absolute((double)leftRight[0], (double)commonHeight));
        right.setSizeSpec(PointSpec.absolute((double)leftRight[1], (double)commonHeight));
        left.setPositionSpec(PointSpec.absolute((double)0.0, (double)0.0));
        right.setPositionSpec(PointSpec.absolute((double)(containerWidth - leftRight[1]), (double)0.0));
    }

    protected void layoutVertical(Shape top, Shape bottom, IDrawContext drawContext, Dimension2D containerSize) {
        double commonWidth = containerSize.getWidth();
        double containerHeight = containerSize.getHeight();
        double topMin = ExtendedAppearanceGroup.getMinHeight(top, drawContext);
        double bottomMin = ExtendedAppearanceGroup.getMinHeight(bottom, drawContext);
        double topMax = ExtendedAppearanceGroup.getMaxHeight(top, drawContext, commonWidth);
        double bottomMax = ExtendedAppearanceGroup.getMaxHeight(bottom, drawContext, commonWidth);
        double[] topBottom = this.allocateSpace(topMin, topMax, bottomMin, bottomMax, containerHeight);
        top.setSizeSpec(PointSpec.absolute((double)commonWidth, (double)topBottom[0]));
        bottom.setSizeSpec(PointSpec.absolute((double)commonWidth, (double)topBottom[1]));
        top.setPositionSpec(PointSpec.absolute((double)0.0, (double)(containerHeight - topBottom[0])));
        bottom.setPositionSpec(PointSpec.absolute((double)0.0, (double)0.0));
    }

    public void setGraphics(Shape potentialGraphics) {
        this.potentialGraphics = potentialGraphics;
    }

    public void setImage(ILocator locator, RectAlignment alignment) {
        None shape;
        if (locator == null) {
            shape = None.create((IArgs)Args.create());
        } else {
            Image image = Image.create((IArgs)Args.create());
            image.setImage(locator);
            shape = image;
        }
        shape.setSizeSpec(PointSpec.percent((double)100.0, (double)100.0));
        shape.setAlignment(alignment);
        this.setGraphics((Shape)shape);
    }

    public void setLayout(EnumBlockLayout layout) {
        this.layout = layout;
    }

    public void setText(Shape potentialText) {
        this.potentialText = potentialText;
    }

    public void setText(String string, RectAlignment alignment) {
        None shape;
        if (string == null) {
            shape = None.create((IArgs)Args.create());
        } else {
            Text text = Text.create((IArgs)Args.create());
            text.setText(string);
            shape = text;
        }
        shape.setSizeSpec(PointSpec.percent((double)100.0, (double)100.0));
        shape.setAlignment(alignment);
        this.setText((Shape)shape);
    }

    private static class ExtendedResize
    implements IResize {
        private IResize delegate;

        public ExtendedResize(IResize delegate) {
            this.delegate = delegate;
        }

        public boolean isDeflate() {
            return true;
        }

        public boolean isEnclose() {
            return true;
        }

        public boolean isFill() {
            return this.delegate.isFill();
        }

        public boolean isGrow() {
            return this.delegate.isGrow();
        }

        public boolean isInflate() {
            return true;
        }

        public boolean isNever() {
            return this.delegate.isNever();
        }

        public boolean isShrink() {
            return this.delegate.isShrink();
        }
    }
}

