/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.signature;

import de.intarsys.document.model.IDocument;
import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.design.widget.IFieldReference;
import de.intarsys.pdf.design.widget.NewFieldReference;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.security.document.type.pdf.signature.PDFDocumentSigner;
import de.intarsys.tools.factory.IFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PDFDocumentFieldOnlySigner
extends CommonDocumentProcessor {
    private static final Logger Log = LoggerFactory.getLogger(PDFDocumentFieldOnlySigner.class);

    public PDFDocumentFieldOnlySigner(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected void basicRun() throws Exception {
        PDAFSignatureField field;
        IFieldReference fieldRef = PDFDocumentSigner.getFieldReference(this.getArgs());
        if (fieldRef == null) {
            if (Log.isEnabledForLevel(Level.TRACE)) {
                Log.trace("no field position set, creating invisble signature position.");
            }
            fieldRef = new NewFieldReference((PDDocument)this.getDocument().getImpl(), "Sig");
        }
        if ((field = (PDAFSignatureField)fieldRef.getField()) == null) {
            throw new IllegalArgumentException("signature field '" + fieldRef.getFieldName() + "' doesn't exist");
        }
        if (fieldRef.isVisible()) {
            AppearanceCreatorTools.createAppearance((PDAcroFormField)field);
        }
        this.saveDocument(null);
        this.setResult(this.getDocument());
        this.ok();
    }
}

