/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.signature;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.FormFilter;
import de.intarsys.document.type.pdf.PageProcessorTools;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.design.CommonAnnotationReference;
import de.intarsys.pdf.design.widget.FieldDefinitionTools;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.design.widget.IFieldReference;
import de.intarsys.pdf.pd.PDBuildData;
import de.intarsys.pdf.pd.PDBuildProperties;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignatureLock;
import de.intarsys.processor.model.IProcessor;
import de.intarsys.processor.pdf.common.WaterMarkCreator;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.document.type.pdf.common.PDFSecurityEnvironment;
import de.intarsys.security.document.type.pdf.signature.DefaultDecoratorFactory;
import de.intarsys.security.document.type.pdf.signature.ISignatureDecorator;
import de.intarsys.security.document.type.pdf.signature.PACKAGE;
import de.intarsys.security.method.pdf.common.PDFAdditionalInfoSet;
import de.intarsys.security.method.pdf.signature.EnumPermissions;
import de.intarsys.security.method.pdf.signature.IPDDocumentSigner;
import de.intarsys.security.method.pdf.signature.ISignatureModifier;
import de.intarsys.security.method.pdf.signature.PDDocumentSignerParameters;
import de.intarsys.security.method.pdf.signature.PDDocumentSignerTools;
import de.intarsys.security.processor.signature.DeviceBasedDocumentSigner;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.security.processor.signature.SameDocumentLocatorStrategy;
import de.intarsys.security.processor.signature.SignatureLocatorCreationStrategy;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfo;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfoSet;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.range.IRangeContext;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.system.SystemTools;
import de.intarsys.tools.tag.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFDocumentSigner
extends DeviceBasedDocumentSigner {
    public static final String ARG_EMBEDFONTS = "embedFonts";
    public static final String ARG_FIELD = "field";
    public static final String ARG_SIGNATURE_LABEL = "signatureLabel";
    public static final String ARG_CERTIFICATIONSIGNATURE = "certificationSignature";
    public static final String ARG_PERMISSIONS = "permissions";
    public static final String ARG_PREPROCESSOR = "preprocessor";
    public static final String ARG_LOCK = "lock";
    private static final Logger Log = LoggerFactory.getLogger(PDFDocumentSigner.class);
    public static final String ARG_LOCK_FIELDS = "fields";
    public static final String ARG_LOCK_FILTER = "filter";
    public static final String ARG_FORMAT = "format";
    public static final String ARG_SKIPPERMISSIONCHECK = "skipPermissionCheck";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IFactory<IPDDocumentSigner> pdDocumentSignerFactory;
    private IAdditionalInfoSet additionalInfoSet;
    private ILocator rollbackLocator;
    private ILocator tempLocator;

    protected static PDSignatureLock createSignatureLock(IArgs args) {
        if (args.get(ARG_LOCK_FILTER) == null) {
            return null;
        }
        PDSignatureLock lock = (PDSignatureLock)PDSignatureLock.META.createNew();
        FormFilter filter = (FormFilter)ArgTools.getEnumItem((IArgs)args, (EnumMeta)FormFilter.META, (String)ARG_LOCK_FILTER, (EnumItem)FormFilter.ALL);
        COSName action = filter == FormFilter.ALL ? PDSignatureLock.CN_All : (filter == FormFilter.INCLUDE ? PDSignatureLock.CN_Include : (filter == FormFilter.EXCLUDE ? PDSignatureLock.CN_Exclude : PDSignatureLock.CN_All));
        lock.cosSetAction(action);
        List fields = ArgTools.getList((IArgs)args, (String)ARG_LOCK_FIELDS, new ArrayList());
        lock.setFields(fields);
        return lock;
    }

    public static IFactory<IPDDocumentSigner> getDocumentSignerFactory(Object format) throws ObjectCreationException {
        if (format instanceof IFactory) {
            return (IFactory)format;
        }
        try {
            String formatId = (String)ConverterRegistry.get().convert(format, String.class);
            IFactory factory = FactoryTools.lookupFactoryFor(IPDDocumentSigner.class, (List)ListTools.with((Object[])new Tag[]{new Tag(ARG_FORMAT, formatId)}));
            if (factory == null && (factory = FactoryTools.lookupFactory((String)formatId, null)) == null) {
                throw new ObjectCreationException("Invalid PDF signature format: " + formatId);
            }
            return factory;
        }
        catch (ConversionException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    public static IFieldReference getFieldReference(IArgs args) throws ConversionException {
        IDocument idoc = null;
        try {
            idoc = DocumentTools.getDocumentOrCurrent((IArgs)args, (String)"document");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (idoc == null) {
            return null;
        }
        PDDocument pddoc = (PDDocument)idoc.getImpl();
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put("fieldType", "Sig");
        IRangeContext rangeContext = PageProcessorTools.createRangeContext((IDocument)idoc);
        return PageProcessorTools.getFieldReference((IArgs)args, (String)ARG_FIELD, (PDDocument)pddoc, (IRangeContext)rangeContext, overrideMap);
    }

    public static IFactory<IPDDocumentSigner> getFormat(IArgs args, Object defaultValue) throws ObjectCreationException {
        Object format = args.get(ARG_FORMAT);
        if (format == null) {
            format = defaultValue;
        }
        return PDFDocumentSigner.getDocumentSignerFactory(format);
    }

    public static EnumPermissions getPermissions(IArgs args) {
        return (EnumPermissions)ArgTools.getEnumItem((IArgs)args, (EnumMeta)EnumPermissions.META, (String)ARG_PERMISSIONS);
    }

    public static IProcessor getPreprocessor(IArgs args) throws ObjectCreationException {
        return (IProcessor)InstanceSpec.getAsInstance((IArgs)args, (String)ARG_PREPROCESSOR, IProcessor.class);
    }

    public static String getSignatureLabel(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)ARG_SIGNATURE_LABEL, null);
    }

    public static PDSignatureLock getSignatureLock(IArgs args) {
        Object argValue = args.get(ARG_LOCK);
        if (argValue instanceof PDSignatureLock) {
            return (PDSignatureLock)argValue;
        }
        IArgs lockArgs = ArgTools.toArgs((Object)argValue);
        if (lockArgs != null) {
            return PDFDocumentSigner.createSignatureLock(lockArgs);
        }
        return null;
    }

    public static boolean isCertificationSignature(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)ARG_CERTIFICATIONSIGNATURE, (boolean)false);
    }

    public static boolean isSkipPermissionCheck(IArgs args) {
        return ArgTools.getBool((IArgs)args, (String)ARG_SKIPPERMISSIONCHECK, (boolean)false);
    }

    public PDFDocumentSigner(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected void basicCancel() {
        this.rollbackDocument();
        super.basicCancel();
    }

    protected IConversation<ISignatureContainer> basicSign(IDigester digester) {
        try {
            this.checkSignedDocumentConsistency();
            ILocator source = this.getDocument().getLocator();
            this.setRollbackLocator(source);
            ILocator destination = this.createDestinationLocator(source);
            this.setTempLocator(PDFSecurityEnvironment.get().getTransientLocatorFactory().createLocator(source));
            this.preprocess();
            IPDDocumentSigner builder = this.createSignatureContainerBuilder(digester);
            PDDocumentSignerParameters docSignerParameters = this.createPDDocumentSignerParameters();
            PDDocument doc = (PDDocument)this.getDocument().getImpl();
            IConversation conversation = builder.sign(doc, this.getTempLocator(), docSignerParameters);
            return conversation.thenApply(result -> {
                this.saveDocument(destination);
                return result;
            });
        }
        catch (DocumentSignerException | ConversionException | IllegalArgumentException e) {
            return Conversation.failed((Throwable)e);
        }
        catch (SecurityApplicationException ex) {
            return Conversation.failed((Throwable)new DocumentSignerException(ex.getLocalizedMessage(), (Throwable)ex));
        }
        catch (IOException e) {
            String msg = Msg.getString("PDFDocumentSigner.ExIO", new Object[]{e.getLocalizedMessage()});
            return Conversation.failed((Throwable)new DocumentSignerException(msg, (Throwable)e));
        }
        catch (Exception e) {
            Object msg = Msg.getString("PDFDocumentSigner.ExUnexpected", new Object[0]);
            msg = (String)msg + " - " + ExceptionTools.getMessage((Throwable)e);
            return Conversation.failed((Throwable)new DocumentSignerException((String)msg, (Throwable)e));
        }
    }

    protected void basicStop() throws Exception {
        this.rollbackTempLocator();
        super.basicStop();
    }

    protected PDBuildProperties createBuildProperties() {
        String appName = ((Object)((Object)this)).getClass().getName();
        Object context = this.getContext();
        if (context instanceof IPresentationSupport) {
            appName = ((IPresentationSupport)context).getLabel();
        }
        String osName = SystemTools.getOSName();
        int revision = 400;
        PDBuildProperties propBuild = (PDBuildProperties)PDBuildProperties.META.createNew();
        PDBuildData app = (PDBuildData)PDBuildData.META.createNew();
        propBuild.setApp(app);
        app.setName(appName);
        app.setOS(osName);
        app.setR(revision);
        PDBuildData pubSec = (PDBuildData)PDBuildData.META.createNew();
        propBuild.setPubSec(pubSec);
        pubSec.setR(revision);
        pubSec.setV(1);
        pubSec.setNonEFontNoWarn(true);
        return propBuild;
    }

    protected ISignatureModifier createModifier(IArgs modifier) throws ObjectCreationException {
        InstanceSpec spec = InstanceSpec.createFromArgs(ISignatureModifier.class, (Object)modifier);
        return (ISignatureModifier)spec.createInstance();
    }

    protected ISignatureModifier createModifier(Object modifier) throws ObjectCreationException {
        if (modifier == null) {
            return null;
        }
        if (modifier instanceof ISignatureModifier) {
            return (ISignatureModifier)modifier;
        }
        if (modifier instanceof IArgs) {
            return this.createModifier((IArgs)modifier);
        }
        throw new ObjectCreationException("'modifier' " + modifier + " not supported");
    }

    protected List<ISignatureModifier> createModifierList() throws ObjectCreationException {
        Object modifier = ArgTools.getObject((IArgs)this.getArgs(), (String)"modifier", null);
        if (modifier == null) {
            return Collections.emptyList();
        }
        if (modifier instanceof IArgs) {
            return this.createModifierList((IArgs)modifier);
        }
        throw new ObjectCreationException("'modifier' " + modifier + " not supported");
    }

    protected List<ISignatureModifier> createModifierList(IArgs modifier) throws ObjectCreationException {
        if (InstanceSpec.isInstanceSpec((IArgs)modifier)) {
            return ListTools.with((Object[])new ISignatureModifier[]{this.createModifier(modifier)});
        }
        ArrayList<ISignatureModifier> result = new ArrayList<ISignatureModifier>();
        for (IArgs.IBinding binding : modifier) {
            result.add(this.createModifier(binding.getValue()));
        }
        return result;
    }

    protected PDDocumentSignerParameters createPDDocumentSignerParameters() throws Exception {
        PDDocumentSignerParameters parameters = new PDDocumentSignerParameters();
        parameters.setFieldDefinition(this.getFieldDefinition());
        parameters.setFieldReference(PDFDocumentSigner.getFieldReference(this.getArgs()));
        parameters.setAppearanceCreator(this.getAppearanceCreator());
        parameters.setCreateCertificationSignature(PDFDocumentSigner.isCertificationSignature(this.getArgs()));
        parameters.setPermissions(PDFDocumentSigner.getPermissions(this.getArgs()));
        parameters.setLock(PDFDocumentSigner.getSignatureLock(this.getArgs()));
        parameters.setModifier(this.createModifierList());
        parameters.setSkipPermissionCheck(PDFDocumentSigner.isSkipPermissionCheck(this.getArgs()));
        return parameters;
    }

    protected IPDDocumentSigner createSignatureContainerBuilder(IDigester digester) throws Exception {
        IArgs signerArgs = this.getArgs().copy();
        signerArgs.put("additionalInfoSet", (Object)this.getAdditionalInfoSetExpanded());
        signerArgs.put("buildProperties", (Object)this.createBuildProperties());
        signerArgs.put("digester", (Object)digester);
        signerArgs.put("signer", (Object)this.getDigestSigner());
        signerArgs.put("timestampDevice", this.getTimestampDevice());
        signerArgs.put("attributeCertificates", (Object)this.getAttributeCertificates());
        try {
            return (IPDDocumentSigner)this.getPDDocumentSignerFactory().createInstance(signerArgs);
        }
        catch (ObjectCreationException e) {
            throw new DocumentSignerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void createUnprefixedResolver(MapResolver resolver) {
        super.createUnprefixedResolver(resolver);
        resolver.put("info", () -> this.getAdditionalInfoSetExpanded());
    }

    public IAdditionalInfoSet getAdditionalInfoSet() {
        return PDDocumentSignerTools.getAdditionalInfoSet((IArgs)this.getArgs());
    }

    public IAdditionalInfoSet getAdditionalInfoSetExpanded() {
        if (this.additionalInfoSet == null) {
            this.additionalInfoSet = new PDFAdditionalInfoSet();
            IAdditionalInfoSet tempInfos = this.getAdditionalInfoSet();
            if (tempInfos != null) {
                IStringEvaluator evaluator = this.getTemplateEvaluator();
                for (IAdditionalInfo info : tempInfos.getDefinition()) {
                    String tempValue = tempInfos.getValue(info);
                    if (tempValue == null) continue;
                    tempValue = StringEvaluatorTools.evaluateString((IStringEvaluator)evaluator, (String)tempValue);
                    this.additionalInfoSet.setValue(info, tempValue);
                }
            }
            return this.additionalInfoSet;
        }
        return this.additionalInfoSet;
    }

    protected IAppearanceCreator getAppearanceCreator() throws Exception {
        ISignatureDecorator decorator;
        try {
            decorator = this.getDecorator();
        }
        catch (ObjectCreationException e) {
            throw new DocumentSignerException(e.getLocalizedMessage(), (Throwable)e);
        }
        IAppearanceCreator appearanceCreator = decorator.getAppearanceCreator();
        if (appearanceCreator == null) {
            IFactory factory = FactoryTools.lookupFactory(DefaultDecoratorFactory.class);
            decorator = (ISignatureDecorator)factory.createInstance((IArgs)Args.create());
            decorator.setDocumentSigner(this);
            appearanceCreator = decorator.getAppearanceCreator();
        }
        return appearanceCreator;
    }

    public ISignatureDecorator getDecorator() throws ObjectCreationException {
        ISignatureDecorator decorator;
        InstanceSpec decoratorSpec = InstanceSpec.get((IArgs)this.getArgs(), (String)"decorator", ISignatureDecorator.class, null);
        if (decoratorSpec == null) {
            decoratorSpec = InstanceSpec.createFromFactory(ISignatureDecorator.class, (Object)DefaultDecoratorFactory.ID, (Object)Args.create());
        }
        if (decoratorSpec.getFactory() == null && decoratorSpec.isInstanceUndefined()) {
            decoratorSpec.setFactory((Object)DefaultDecoratorFactory.ID);
        }
        if ((decorator = (ISignatureDecorator)decoratorSpec.createInstance()) == null) {
            throw new ObjectCreationException("cannot create decorator");
        }
        decorator.setDocumentSigner(this);
        return decorator;
    }

    protected String getDefaultFieldContents() {
        return Msg.getString("PDFDocumentSigner.defaultFieldContents", new Object[0]);
    }

    protected String getDefaultFieldSubject() {
        return Msg.getString("PDFDocumentSigner.defaultFieldSubject", new Object[0]);
    }

    protected String getDefaultFieldTitle() {
        return Msg.getString("PDFDocumentSigner.defaultFieldTitle", new Object[0]);
    }

    protected IFieldDefinition getFieldDefinition() throws Exception {
        PDDocument pddoc = (PDDocument)this.getDocument().getImpl();
        ArgTools.putPathIfAbsent((IArgs)this.getArgs(), (String)"field.fieldType", (Object)"Sig");
        IRangeContext rangeContext = PageProcessorTools.createRangeContext((IDocument)this.getDocument());
        IFieldDefinition fieldDefinition = FieldDefinitionTools.getFieldDefinition((IArgs)this.getArgs(), (String)ARG_FIELD, (PDDocument)pddoc, (IStringEvaluator)this, (IRangeContext)rangeContext, (IAppearanceCreator)this.getAppearanceCreator());
        if (StringTools.isEmpty((String)fieldDefinition.getDefaultAnnotationDefinition().getTitle())) {
            fieldDefinition.getDefaultAnnotationDefinition().setTitle(this.getDefaultFieldTitle());
        }
        if (StringTools.isEmpty((String)fieldDefinition.getDefaultAnnotationDefinition().getSubject())) {
            fieldDefinition.getDefaultAnnotationDefinition().setSubject(this.getDefaultFieldSubject());
        }
        if (StringTools.isEmpty((String)fieldDefinition.getDefaultAnnotationDefinition().getContents())) {
            fieldDefinition.getDefaultAnnotationDefinition().setContents(this.getDefaultFieldContents());
        }
        return fieldDefinition;
    }

    protected SignatureLocatorCreationStrategy getLocatorCreationStrategy() {
        SameDocumentLocatorStrategy strategy = new SameDocumentLocatorStrategy();
        return strategy;
    }

    public IFactory<IPDDocumentSigner> getPDDocumentSignerFactory() {
        return this.pdDocumentSignerFactory;
    }

    public ILocator getRollbackLocator() {
        return this.rollbackLocator;
    }

    public String getSignatureLabel() {
        return PDFDocumentSigner.getSignatureLabel(this.getArgs());
    }

    protected String getSignedDocManipulationMessage() {
        return Msg.getString("PDFSignFunctor.ErrorDocInconsistency", new Object[0]);
    }

    public ILocator getTempLocator() {
        return this.tempLocator;
    }

    protected final boolean isAuthorized() {
        if (!super.isAuthorized()) {
            if (LicenseTools.requestWatermarkConsent((Object)this.getFactory())) {
                WaterMarkCreator.get().doMark(this.getDocument());
                try {
                    this.getDocument().invoke("save", (IArgs)Args.create());
                }
                catch (MethodException e) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean isEmbedFonts() {
        return ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)ARG_EMBEDFONTS, (boolean)true);
    }

    protected void preprocess() throws ObjectCreationException, FunctorException {
        Args preprocessorArgs = Args.create();
        preprocessorArgs.put("signer", (Object)this);
        IProcessor preprocessor = PDFDocumentSigner.getPreprocessor(this.getArgs());
        if (preprocessor != null) {
            FunctorTools.asResult((Object)preprocessor);
        }
    }

    protected void rollbackDocument() {
        if (this.getRollbackLocator() == null) {
            return;
        }
        try {
            IFieldReference fieldReference;
            if (this.getDocument() != null) {
                ((PDDocument)this.getDocument().getImpl()).restore(this.getRollbackLocator());
            }
            if ((fieldReference = PDFDocumentSigner.getFieldReference(this.getArgs())) instanceof CommonAnnotationReference) {
                ((CommonAnnotationReference)fieldReference).refresh();
            }
        }
        catch (Exception ex) {
            Log.warn("rollback failed", (Throwable)ex);
        }
    }

    protected void rollbackTempLocator() {
        try {
            if (this.getTempLocator() != null) {
                this.getTempLocator().delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPDDocumentSignerFactory(IFactory<IPDDocumentSigner> pdDocumentSignerFactory) {
        this.pdDocumentSignerFactory = pdDocumentSignerFactory;
    }

    public void setRollbackLocator(ILocator initialLocator) {
        this.rollbackLocator = initialLocator;
    }

    public void setTempLocator(ILocator tempLocator) {
        this.tempLocator = tempLocator;
    }
}

