/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.signature;

import de.intarsys.pdf.design.widget.IFieldReference;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.security.document.type.pdf.signature.PACKAGE;
import de.intarsys.security.document.type.pdf.signature.PDFDocumentSigner;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.presentation.IPresentationSupport;
import java.awt.geom.Point2D;

public class SignerFieldReference
implements IFieldReference,
IPresentationSupport {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IArgs args;

    public SignerFieldReference(IArgs args) {
        this.args = args;
    }

    public IFieldReference createInContext(PDDocument doc) {
        return this;
    }

    public PDAnnotation getAnnotation() {
        return this.getReference().getAnnotation();
    }

    public IArgs getArgs() {
        return this.args;
    }

    public String getDescription() {
        return this.getLabel();
    }

    public PDDocument getDocument() {
        return this.getReference().getDocument();
    }

    public PDAcroFormField getField() {
        IFieldReference fieldRef = this.getReference();
        if (fieldRef == null) {
            return null;
        }
        return fieldRef.getField();
    }

    public String getFieldName() {
        return this.getLabel();
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        if (this.getReference().isNew()) {
            return Msg.getString("SignerFieldReference.FieldLabel", new Object[0]);
        }
        return this.getField().getQualifiedName();
    }

    public Point2D getPosition() {
        return this.getReference().getPosition();
    }

    protected IFieldReference getReference() {
        IFieldReference fieldRef;
        try {
            fieldRef = PDFDocumentSigner.getFieldReference(this.getArgs());
        }
        catch (ConversionException ex) {
            throw new UnreachableCodeError();
        }
        if (fieldRef != null) {
            this.getArgs().put("field", (Object)fieldRef);
        }
        return fieldRef;
    }

    public Point2D getSize() {
        return this.getReference().getSize();
    }

    public String getTip() {
        return this.getLabel();
    }

    public boolean isNew() {
        return this.getReference().isNew();
    }

    public boolean isVisible() {
        return this.getReference().isVisible();
    }
}

