/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.signature.legacy;

import de.intarsys.security.document.type.pdf.signature.legacy.LegacySample;
import de.intarsys.security.document.type.pdf.signature.legacy.LegacySampleProvider;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public class LegacyJSSignaturePad
extends LegacySampleProvider {
    private static final int M12 = 5;
    private static final int M02 = 4;
    private static final int M11 = 3;
    private static final int M01 = 2;
    private static final int M10 = 1;
    private static final int M00 = 0;
    private double minX = Double.MAX_VALUE;
    private double minY = Double.MAX_VALUE;
    private double maxX;
    private double maxY;

    public static double toDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        return 0.0;
    }

    protected void createSamples(IArgs args) {
        List transformList = ArgTools.getList((IArgs)args, (String)"transform", null);
        AffineTransform transform = new AffineTransform(((Number)transformList.get(0)).doubleValue(), ((Number)transformList.get(1)).doubleValue(), ((Number)transformList.get(2)).doubleValue(), ((Number)transformList.get(3)).doubleValue(), ((Number)transformList.get(4)).doubleValue(), ((Number)transformList.get(5)).doubleValue());
        IArgs samples = ArgTools.getArgs((IArgs)args, (String)"samples", (IArgs)Args.create());
        if (samples.size() == 0) {
            this.minX = 0.0;
            this.minY = 0.0;
            this.maxX = 0.0;
            this.maxY = 0.0;
        }
        Iterator itSamples = samples.bindings();
        while (itSamples.hasNext()) {
            IArgs sample = (IArgs)((IArgs.IBinding)itSamples.next()).getValue();
            int force = 0;
            IArgs xEvents = (IArgs)sample.get("x");
            IArgs yEvents = (IArgs)sample.get("y");
            Iterator itX = xEvents.bindings();
            Iterator itY = yEvents.bindings();
            while (itX.hasNext() && itY.hasNext()) {
                Point2D.Double ptSrc = new Point2D.Double();
                Point2D.Double ptDst = new Point2D.Double();
                ((Point2D)ptSrc).setLocation(LegacyJSSignaturePad.toDouble(((IArgs.IBinding)itX.next()).getValue()), LegacyJSSignaturePad.toDouble(((IArgs.IBinding)itY.next()).getValue()));
                transform.transform(ptSrc, ptDst);
                if (((Point2D)ptDst).getX() < this.minX) {
                    this.minX = ((Point2D)ptDst).getX();
                }
                if (((Point2D)ptDst).getX() > this.maxX) {
                    this.maxX = ((Point2D)ptDst).getX();
                }
                if (((Point2D)ptDst).getY() < this.minY) {
                    this.minY = ((Point2D)ptDst).getY();
                }
                if (((Point2D)ptDst).getY() > this.maxY) {
                    this.maxY = ((Point2D)ptDst).getY();
                }
                this.addSample(new LegacySample((int)((Point2D)ptDst).getX(), (int)((Point2D)ptDst).getY(), force));
                force = 1;
            }
        }
    }

    @Override
    protected void initFromArgs(IArgs args) {
        this.setMaxForce(1);
        this.createSamples(args);
        this.setRect(new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY));
    }
}

