/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.signature.legacy;

import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.image.IImage;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.tools.exception.UnreachableCodeError;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Map;

public class LegacyPdfGraphicsContext
implements IGraphicsContext {
    private static final int SEGMENT_SIZE = 6;
    private final CSCreator csCreator;

    public LegacyPdfGraphicsContext(CSCreator csCreator) {
        this.csCreator = csCreator;
    }

    public void clip(Shape shape) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public void draw(Shape s) {
        PathIterator pathIterator = s.getPathIterator(null);
        float[] coords = new float[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    this.csCreator.penMoveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    this.csCreator.penLineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.csCreator.penCurveToC(coords[0], coords[1], coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            pathIterator.next();
        }
        this.csCreator.pathStroke();
    }

    public void drawImage(IImage image, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void drawString(String text, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void fill(Shape s) {
        throw new UnsupportedOperationException();
    }

    public Color getBackgroundColor() {
        throw new UnsupportedOperationException();
    }

    public Shape getClip() {
        throw new UnsupportedOperationException();
    }

    public Color getForegroundColor() {
        throw new UnsupportedOperationException();
    }

    public IGraphicsEnvironment getGraphicsEnvironment() {
        throw new UnsupportedOperationException();
    }

    public RenderingHints getRenderingHints() {
        throw new UnsupportedOperationException();
    }

    public AffineTransform getTransform() {
        throw new UnsupportedOperationException();
    }

    public void rotate(float theta) {
        throw new UnsupportedOperationException();
    }

    public void scale(float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void setBackgroundColor(Color color) {
        throw new UnsupportedOperationException();
    }

    public void setBackgroundPaint(IPaint paint) {
        throw new UnsupportedOperationException();
    }

    public void setClip(Shape shape) {
        throw new UnsupportedOperationException();
    }

    public void setFont(Font font) {
        throw new UnsupportedOperationException();
    }

    public void setForegroundColor(Color c) {
        int rgb = c.getRGB();
        this.csCreator.setStrokeColorRGB((float)((rgb & 0xFF0000) >> 16) / 255.0f, (float)((rgb & 0xFF00) >> 8) / 255.0f, (float)(rgb & 0xFF) / 255.0f);
    }

    public void setForegroundPaint(IPaint paint) {
        throw new UnsupportedOperationException();
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        throw new UnsupportedOperationException();
    }

    public void setRenderingHints(Map hints) {
        throw new UnsupportedOperationException();
    }

    public void setStroke(Stroke s) {
        if (!(s instanceof BasicStroke)) {
            throw new UnsupportedOperationException();
        }
        BasicStroke basicStroke = (BasicStroke)s;
        float lineWidth = basicStroke.getLineWidth();
        this.csCreator.setLineWidth(lineWidth);
        int endCap = basicStroke.getEndCap();
        switch (endCap) {
            case 0: {
                this.csCreator.setLineCap(0);
                break;
            }
            case 1: {
                this.csCreator.setLineCap(1);
                break;
            }
            case 2: {
                this.csCreator.setLineCap(2);
                break;
            }
            default: {
                throw new UnreachableCodeError();
            }
        }
        int lineJoin = basicStroke.getLineJoin();
        switch (lineJoin) {
            case 0: {
                this.csCreator.setLineJoin(0);
                break;
            }
            case 1: {
                this.csCreator.setLineJoin(1);
                break;
            }
            case 2: {
                this.csCreator.setLineJoin(2);
                break;
            }
            default: {
                throw new UnreachableCodeError();
            }
        }
    }

    public void setTransform(AffineTransform transform) {
        throw new UnsupportedOperationException();
    }

    public void transform(AffineTransform transform) {
        throw new UnsupportedOperationException();
    }

    public void translate(float x, float y) {
        throw new UnsupportedOperationException();
    }
}

