/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.signature.legacy;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.security.document.type.pdf.signature.legacy.LegacySample;
import de.intarsys.security.document.type.pdf.signature.legacy.LegacySampleProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;

public class LegacySampleRenderer {
    private static final float DEFAULT_WIDTH = 3.0f;
    private static final double DELTA = 0.02;
    private static final float DEFAULT_BRIGHTNESS_MAX = 0.9f;
    private static final float DEFAULT_BRIGHTNESS_MIN = 0.4f;
    private static final float DEFAULT_BRIGHTNESS_RANGE = 0.49999997f;
    private static final float DEFAULT_HUE = 0.66f;
    private static final float DEFAULT_SATURATION = 1.0f;
    private final LegacySampleProvider sampleProvider;

    public LegacySampleRenderer(LegacySampleProvider sampleProvider) {
        this.sampleProvider = sampleProvider;
    }

    protected float brightness(float f) {
        return 0.9f - f * 0.49999997f / (float)this.getSampleProvider().getMaxForce();
    }

    protected void drawPath(IGraphicsContext graphics, Path2D path) {
        PathIterator pathIterator = path.getPathIterator(null);
        pathIterator.next();
        if (!pathIterator.isDone()) {
            graphics.draw((Shape)path);
        }
    }

    public LegacySampleProvider getSampleProvider() {
        return this.sampleProvider;
    }

    public void renderSamples(IGraphicsContext graphics) {
        this.renderSamplesPlain(graphics);
    }

    protected void renderSamplesPlain(IGraphicsContext graphics) {
        graphics.setStroke((Stroke)new BasicStroke(3.0f, 1, 1));
        float oldBrightness = Float.MIN_VALUE;
        Path2D path = null;
        for (LegacySample sample : this.getSampleProvider().getSamples()) {
            int newF = sample.getF();
            if (newF > 0) {
                double x = sample.getX();
                double y = sample.getY();
                float newBrightness = this.brightness(newF);
                float difference = Math.abs(newBrightness - oldBrightness);
                if ((double)difference >= 0.02) {
                    if (path != null) {
                        path.lineTo(x, y);
                        graphics.draw((Shape)path);
                    }
                    graphics.setForegroundColor(new Color(this.rgb(newBrightness)));
                    path = new Path2D.Double();
                    path.moveTo(x, y);
                    oldBrightness = newBrightness;
                    continue;
                }
                if (path == null) {
                    path = new Path2D.Double();
                    path.moveTo(x, y);
                    continue;
                }
                path.lineTo(x, y);
                continue;
            }
            if (path == null) continue;
            this.drawPath(graphics, path);
            path = null;
        }
        if (path != null) {
            this.drawPath(graphics, path);
        }
    }

    protected void renderSamplesSmooth(IGraphicsContext graphics) {
        graphics.setStroke((Stroke)new BasicStroke(3.0f, 1, 1));
        float oldBrightness = Float.MIN_VALUE;
        Path2D.Double path = null;
        int index = 0;
        double prevX = 0.0;
        double prevY = 0.0;
        for (LegacySample sample : this.getSampleProvider().getSamples()) {
            int newF = sample.getF();
            if (newF > 0) {
                ++index;
                double x = sample.getX();
                double y = sample.getY();
                float newBrightness = this.brightness(newF);
                float difference = Math.abs(newBrightness - oldBrightness);
                if ((double)difference >= 0.02) {
                    if (path != null) {
                        midX = (prevX + x) / 2.0;
                        midY = (prevY + y) / 2.0;
                        if (index == 1) {
                            ((Path2D)path).lineTo(midX, midY);
                        } else {
                            ((Path2D)path).quadTo(prevX, prevY, midX, midY);
                        }
                        graphics.draw((Shape)path);
                    }
                    graphics.setForegroundColor(new Color(this.rgb(newBrightness)));
                    index = 0;
                    path = new Path2D.Double();
                    ((Path2D)path).moveTo(x, y);
                    oldBrightness = newBrightness;
                } else if (path == null) {
                    index = 0;
                    path = new Path2D.Double();
                    ((Path2D)path).moveTo(x, y);
                } else {
                    midX = (prevX + x) / 2.0;
                    midY = (prevY + y) / 2.0;
                    if (index == 1) {
                        ((Path2D)path).lineTo(midX, midY);
                    } else {
                        ((Path2D)path).quadTo(prevX, prevY, midX, midY);
                    }
                }
                prevX = x;
                prevY = y;
                continue;
            }
            if (path == null) continue;
            this.drawPath(graphics, path);
            path = null;
        }
        if (path != null) {
            this.drawPath(graphics, path);
        }
    }

    protected int rgb(float brightness) {
        return Color.HSBtoRGB(0.66f, 1.0f, brightness);
    }
}

