/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.timestamp;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.PageProcessorTools;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.design.CommonAnnotationReference;
import de.intarsys.pdf.design.widget.FieldDefinitionTools;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.design.widget.IFieldReference;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDBuildData;
import de.intarsys.pdf.pd.PDBuildProperties;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.processor.pdf.common.WaterMarkCreator;
import de.intarsys.security.digest.DigestTools;
import de.intarsys.security.document.type.pdf.common.PDFSecurityEnvironment;
import de.intarsys.security.document.type.pdf.timestamp.PACKAGE;
import de.intarsys.security.method.pdf.signature.DSFactoryPAdESLTVTimestamp;
import de.intarsys.security.method.pdf.signature.IPDDocumentSigner;
import de.intarsys.security.method.pdf.signature.PDDocumentSignerParameters;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.processor.timestamp.CommonDocumentTimestampCreator;
import de.intarsys.security.processor.timestamp.DocumentTimestampException;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.range.IRangeContext;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.system.SystemTools;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PDFDocumentTimestampCreator
extends CommonDocumentTimestampCreator {
    public static final String ARG_EMBEDFONTS = "embedFonts";
    public static final String ARG_FIELD = "field";
    private static final Logger Log = LoggerFactory.getLogger(PDFDocumentTimestampCreator.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static IFieldReference getFieldReference(IArgs args) throws ConversionException {
        IDocument idoc = null;
        try {
            idoc = DocumentTools.getDocumentOrCurrent((IArgs)args, (String)"document");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (idoc == null) {
            return null;
        }
        PDDocument pddoc = (PDDocument)idoc.getImpl();
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put("fieldType", "Sig");
        IRangeContext rangeContext = PageProcessorTools.createRangeContext((IDocument)idoc);
        return PageProcessorTools.getFieldReference((IArgs)args, (String)ARG_FIELD, (PDDocument)pddoc, (IRangeContext)rangeContext, overrideMap);
    }

    public PDFDocumentTimestampCreator(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected ISignatureContainer basicCreateTimestamp() throws DocumentTimestampException {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("internal signing document:" + this.getShortName());
        }
        ILocator source = this.getDocument().getLocator();
        ILocator destination = this.createDestinationLocator();
        ILocator tempLocator = null;
        PDDocument doc = (PDDocument)this.getDocument().getImpl();
        try {
            source = this.getDocument().getLocator();
            destination = this.createDestinationLocator();
            tempLocator = PDFSecurityEnvironment.get().getTransientLocatorFactory().createLocator(source);
            IPDDocumentSigner docSigner = this.createPDDocumentTimestampCreator();
            PDDocumentSignerParameters docSignerParameters = this.createPDDocumentSignerParameters();
            docSigner.sign(doc, tempLocator, docSignerParameters);
            this.saveSignedDocument(destination);
            PDFSignatureContainer pDFSignatureContainer = PDFSignatureContainer.createSignatureContainer((PDDocument)doc);
            return pDFSignatureContainer;
        }
        catch (ConversionException ex) {
            throw this.throwException(new DocumentTimestampException(ex.getLocalizedMessage(), (Throwable)ex), doc, source);
        }
        catch (DocumentTimestampException e) {
            throw this.throwException(e, doc, source);
        }
        catch (IOException e) {
            String msg = Msg.getString("PDFDocumentTimestampCreator.ExIO", new Object[]{e.getLocalizedMessage()});
            throw this.throwException(new DocumentTimestampException(msg, (Throwable)e), doc, source);
        }
        catch (Exception e) {
            String msg = Msg.getString("PDFDocumentTimestampCreator.ExUnexpected", new Object[0]) + " - " + ExceptionTools.getMessageShort((Throwable)e);
            throw this.throwException(new DocumentTimestampException(msg, (Throwable)e), doc, source);
        }
        finally {
            try {
                if (tempLocator != null) {
                    tempLocator.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected PDBuildProperties createBuildProperties() {
        String appName = ((Object)((Object)this)).getClass().getName();
        Object context = this.getContext();
        if (context instanceof IPresentationSupport) {
            appName = ((IPresentationSupport)context).getLabel();
        }
        String osName = SystemTools.getOSName();
        int revision = 400;
        PDBuildProperties propBuild = (PDBuildProperties)PDBuildProperties.META.createNew();
        PDBuildData app = (PDBuildData)PDBuildData.META.createNew();
        propBuild.setApp(app);
        app.setName(appName);
        app.setOS(osName);
        app.setR(revision);
        PDBuildData pubSec = (PDBuildData)PDBuildData.META.createNew();
        propBuild.setPubSec(pubSec);
        pubSec.setR(revision);
        pubSec.setV(1);
        pubSec.setNonEFontNoWarn(true);
        return propBuild;
    }

    protected PDDocumentSignerParameters createPDDocumentSignerParameters() throws Exception {
        PDDocumentSignerParameters parameters = new PDDocumentSignerParameters();
        parameters.setFieldDefinition(this.getFieldDefinition());
        parameters.setFieldReference(PDFDocumentTimestampCreator.getFieldReference(this.getArgs()));
        parameters.setAppearanceCreator(this.getAppearanceCreator());
        return parameters;
    }

    protected IPDDocumentSigner createPDDocumentTimestampCreator() throws DocumentTimestampException {
        try {
            Args signerArgs = Args.create();
            signerArgs.put("buildProperties", (Object)this.createBuildProperties());
            signerArgs.put("digester", (Object)DigestTools.getDigesterOrSha1((IArgs)this.getArgs(), (String)"SHA-1"));
            signerArgs.put("timestampDevice", this.getTimestampDevice());
            return (IPDDocumentSigner)this.getPDDocumentSignerFactory().createInstance((IArgs)signerArgs);
        }
        catch (ObjectCreationException e) {
            throw new DocumentTimestampException();
        }
    }

    protected IAppearanceCreator getAppearanceCreator() throws DocumentTimestampException {
        return null;
    }

    protected String getDefaultFieldContents() {
        return Msg.getString("PDFDocumentTimestampCreator.defaultFieldContents", new Object[0]);
    }

    protected String getDefaultFieldSubject() {
        return Msg.getString("PDFDocumentTimestampCreator.defaultFieldSubject", new Object[0]);
    }

    protected String getDefaultFieldTitle() {
        return Msg.getString("PDFDocumentTimestampCreator.defaultFieldTitle", new Object[0]);
    }

    protected IFieldDefinition getFieldDefinition() throws Exception {
        PDDocument pddoc = (PDDocument)this.getDocument().getImpl();
        ArgTools.putPathIfAbsent((IArgs)this.getArgs(), (String)"field.fieldType", (Object)"Sig");
        IRangeContext rangeContext = PageProcessorTools.createRangeContext((IDocument)this.getDocument());
        MapResolver resolver = new MapResolver(true);
        this.createUnprefixedResolver(resolver);
        IFieldDefinition fieldDefinition = FieldDefinitionTools.getFieldDefinition((IArgs)this.getArgs(), (String)ARG_FIELD, (PDDocument)pddoc, (IStringEvaluator)resolver, (IRangeContext)rangeContext, (IAppearanceCreator)this.getAppearanceCreator());
        if (StringTools.isEmpty((String)fieldDefinition.getDefaultAnnotationDefinition().getTitle())) {
            fieldDefinition.getDefaultAnnotationDefinition().setTitle(this.getDefaultFieldTitle());
        }
        if (StringTools.isEmpty((String)fieldDefinition.getDefaultAnnotationDefinition().getSubject())) {
            fieldDefinition.getDefaultAnnotationDefinition().setSubject(this.getDefaultFieldSubject());
        }
        if (StringTools.isEmpty((String)fieldDefinition.getDefaultAnnotationDefinition().getContents())) {
            fieldDefinition.getDefaultAnnotationDefinition().setContents(this.getDefaultFieldContents());
        }
        return fieldDefinition;
    }

    protected IFactory<IPDDocumentSigner> getPDDocumentSignerFactory() {
        return DSFactoryPAdESLTVTimestamp.get();
    }

    protected boolean isAppend() {
        return false;
    }

    protected final boolean isAuthorized() {
        if (!super.isAuthorized()) {
            if (LicenseTools.requestWatermarkConsent((Object)this.getFactory())) {
                WaterMarkCreator.get().doMark(this.getDocument());
                try {
                    this.getDocument().invoke("save", (IArgs)Args.create());
                }
                catch (MethodException e) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean isCreateAttachment() {
        return false;
    }

    public boolean isEmbedFonts() {
        return ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)ARG_EMBEDFONTS, (boolean)true);
    }

    protected boolean isOverwrite() {
        return true;
    }

    private void rollback(PDDocument doc, ILocator docLocator) {
        try {
            doc.restore(docLocator);
            IFieldReference fieldReference = PDFDocumentTimestampCreator.getFieldReference(this.getArgs());
            if (fieldReference instanceof CommonAnnotationReference) {
                ((CommonAnnotationReference)fieldReference).refresh();
            }
        }
        catch (COSLoadException | ConversionException | IOException ex) {
            Log.warn("rollback failed", ex);
        }
    }

    protected void saveSignedDocument(ILocator destination) throws IOException {
        Args args = Args.create();
        args.put("locator", (Object)destination);
        try {
            this.getDocument().invoke("save", (IArgs)args);
        }
        catch (MethodException e) {
            throw (IOException)ExceptionTools.unwrapTyped((Throwable)e, IOException.class);
        }
    }

    protected DocumentTimestampException throwException(DocumentTimestampException exception, PDDocument doc, ILocator source) {
        this.rollback(doc, source);
        return exception;
    }
}

