/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.validation;

import de.intarsys.security.document.type.pdf.validation.PACKAGE;
import de.intarsys.security.document.type.pdf.validation.SNPDFSignatureEntry;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.tools.message.IMessageBundle;

public class SNPDFCertificationEntry
extends SNPDFSignatureEntry {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public SNPDFCertificationEntry(IValidationState state) {
        super(state);
    }

    public SNPDFCertificationEntry(String name, IValidationState state) {
        super(name, state);
    }

    protected String basicGetLabel(String levelId, String type) {
        if ("simple/advanced".equals(levelId)) {
            if ("personal".equals(type)) {
                return Msg.getString("SNPDFCertificationEntry.LabelSignature", new Object[0]);
            }
            if ("seal".equals(type)) {
                return Msg.getString("SNPDFCertificationEntry.LabelSeal", new Object[0]);
            }
        } else if ("qualified".equals(levelId)) {
            if ("personal".equals(type)) {
                return Msg.getString("SNPDFCertificationEntry.LabelQualifiedSignature", new Object[0]);
            }
            if ("seal".equals(type)) {
                return Msg.getString("SNPDFCertificationEntry.LabelQualifiedSeal", new Object[0]);
            }
        }
        return Msg.getString("SNPDFCertificationEntry.DefaultLabel", new Object[0]);
    }

    protected String getIconInvalid() {
        return "certificate_error";
    }

    protected String getIconUndefined() {
        return "certificate";
    }

    protected String getIconUnknown() {
        return "certificate_information";
    }

    @Override
    protected String getIconValid() {
        if (this.getDigestState().getChangeLevel() >= 1) {
            return "certificate_ok";
        }
        return "certificate_ok";
    }

    protected String getIconWarning() {
        return "certificate_warning";
    }
}

