/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.pdf.validation;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.pd.MDPPermission;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.security.document.type.pdf.validation.PACKAGE;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureEntry;
import de.intarsys.security.method.pdf.validation.PDFSignatureContainerEntryValidator;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.SNSignatureEntry;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.List;

public class SNPDFSignatureEntry
extends SNSignatureEntry {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public SNPDFSignatureEntry(IValidationState state) {
        super(state);
    }

    public SNPDFSignatureEntry(String name, IValidationState state) {
        super(name, state);
    }

    public String getChangeIcon() {
        String icon = null;
        IVSDigest digestState = this.getDigestState();
        int changeLevel = digestState.getChangeLevel();
        switch (changeLevel) {
            case -1: {
                icon = "unknown";
                break;
            }
            case 0: {
                icon = "ok";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                icon = "info";
                break;
            }
            case 99: {
                if (this.getPermissions() == MDPPermission.Undefined) {
                    icon = "unknown";
                    break;
                }
                icon = "error";
                break;
            }
        }
        return icon;
    }

    public List<IValidationMessage> getChangeMessages() {
        List<IDocumentChange> changes = this.getChanges();
        if (changes == null) {
            return null;
        }
        ArrayList<IValidationMessage> messages = new ArrayList<IValidationMessage>();
        for (IDocumentChange change : changes) {
            messages.add(change.getDescription());
        }
        return messages;
    }

    public List<IDocumentChange> getChanges() {
        IVSDigest digestState = this.getDigestState();
        if (digestState == null) {
            return null;
        }
        return digestState.getSubsequentChanges();
    }

    public String getChangeText() {
        String text = null;
        IVSDigest digestState = this.getDigestState();
        int changeLevel = digestState.getChangeLevel();
        switch (changeLevel) {
            case -1: {
                text = Msg.getString("SNPDFSignatureEntry.ChangeTextUndefined", new Object[0]);
                break;
            }
            case 0: {
                text = Msg.getString("SNPDFSignatureEntry.ChangeTextUnchanged", new Object[0]);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.getPermissions() == MDPPermission.Undefined) {
                    text = Msg.getString("SNPDFSignatureEntry.ChangeTextPermittedDefault", new Object[0]);
                    break;
                }
                text = Msg.getString("SNPDFSignatureEntry.ChangeTextPermitted", new Object[0]);
                break;
            }
            case 99: {
                if (this.getPermissions() == MDPPermission.Undefined) {
                    text = Msg.getString("SNPDFSignatureEntry.ChangeTextChangedDefault", new Object[0]);
                    break;
                }
                text = Msg.getString("SNPDFSignatureEntry.ChangeTextChanged", new Object[0]);
                break;
            }
        }
        return text;
    }

    protected String getDefaultName() {
        Object result = super.getDefaultName();
        PDFSignatureEntry entry = (PDFSignatureEntry)this.getState().getEntry();
        if (entry == null || entry.getPDSignature() == null || entry.getPDSignature().getAcroFormField() == null) {
            return result;
        }
        PDAFSignatureField sigfield = entry.getPDSignature().getAcroFormField();
        boolean visible = false;
        for (PDAnnotation anno : sigfield.getAnnotations()) {
            CDSRectangle rect = anno.getRectangle();
            if (rect.getLowerLeftX() - rect.getUpperRightX() == 0.0f && rect.getLowerLeftY() - rect.getUpperRightY() == 0.0f) continue;
            visible = true;
        }
        if (!visible) {
            result = (String)result + " " + Msg.getString("SNPDFSignatureEntry.Invisible", new Object[0]);
        }
        return result;
    }

    protected IVSDigest getDigestState() {
        IVSSignature sigState = this.getState().getSignatureState();
        if (sigState == null) {
            return null;
        }
        if (sigState.getDigestStates().isEmpty()) {
            return null;
        }
        return (IVSDigest)sigState.getDigestStates().get(0);
    }

    protected String getIconValid() {
        if (this.getDigestState().getChangeLevel() >= 1) {
            return super.getIconValid();
        }
        return super.getIconValid();
    }

    protected MDPPermission getPermissions() {
        IVSDigest digestState = this.getDigestState();
        if (digestState == null) {
            return MDPPermission.Undefined;
        }
        Boolean defaultPermissions = (Boolean)digestState.getAttribute((Object)PDFSignatureContainerEntryValidator.STATEATTR_DEFAULTPERMISSIONS);
        if (defaultPermissions == null || defaultPermissions.booleanValue()) {
            return MDPPermission.Undefined;
        }
        MDPPermission permission = (MDPPermission)digestState.getAttribute((Object)PDFSignatureContainerEntryValidator.STATEATTR_PERMISSION);
        if (permission == null) {
            permission = MDPPermission.Undefined;
        }
        return permission;
    }

    public String getPermissionsText() {
        String text = null;
        MDPPermission permissions = this.getPermissions();
        switch (permissions) {
            case NoChanges: {
                text = Msg.getString("SNPDFSignatureEntry.PermissionsText_1", new Object[0]);
                break;
            }
            case FillAndSign: {
                text = Msg.getString("SNPDFSignatureEntry.PermissionsText_2", new Object[0]);
                break;
            }
            case FillSignAndAnnotate: {
                text = Msg.getString("SNPDFSignatureEntry.PermissionsText_3", new Object[0]);
                break;
            }
        }
        return text;
    }

    protected PDFSignatureContainer getSignatureContainer() {
        PDFSignatureEntry entry = (PDFSignatureEntry)this.getState().getEntry();
        if (entry == null) {
            return null;
        }
        PDDocument doc = entry.getDoc();
        return PDFSignatureContainer.createSignatureContainer((PDDocument)doc);
    }
}

