/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.ais;

import ch.swisscom.ais._1_0.schema.SignatureObjectsType;
import com.swisscom.ais.service.IDigitalSignatureService;
import com.swisscom.ais.service.Pending;
import com.swisscom.ais.service.PendingResponse;
import de.intarsys.ais.AisClientException;
import de.intarsys.ais.SSLSocketFactoryWrapper;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import jakarta.xml.ws.WebServiceException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import oasis.names.tc.dss._1_0.core.schema.SignRequest;
import oasis.names.tc.dss._1_0.core.schema.SignResponse;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;

public class AisClient
implements IDigitalSignatureService,
IAttributeSupport {
    private AttributeMap attributes = new AttributeMap();
    private final IDigitalSignatureService service;

    public static AisClient create(String serviceAddress, SSLContext sslContext) throws MalformedURLException {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(IDigitalSignatureService.class);
        factory.setAddress(serviceAddress);
        JAXBDataBinding jaxbDataBinding = new JAXBDataBinding();
        jaxbDataBinding.setExtraClass(new Class[]{SignatureObjectsType.class});
        factory.setDataBinding((DataBinding)jaxbDataBinding);
        IDigitalSignatureService service = (IDigitalSignatureService)factory.create();
        Client client = ClientProxy.getClient((Object)service);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        conduit.getClient().setConnection(ConnectionType.CLOSE);
        TLSClientParameters tlsParams = new TLSClientParameters();
        URL url = new URL(serviceAddress);
        SSLParameters sslParameters = new SSLParameters();
        ArrayList<SNIServerName> sniHostNames = new ArrayList<SNIServerName>(1);
        sniHostNames.add(new SNIHostName(url.getHost()));
        sslParameters.setServerNames(sniHostNames);
        tlsParams.setSSLSocketFactory((SSLSocketFactory)new SSLSocketFactoryWrapper(sslContext.getSocketFactory(), sslParameters));
        conduit.setTlsClientParameters(tlsParams);
        return new AisClient(service);
    }

    private AisClient(IDigitalSignatureService service) {
        this.service = service;
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public PendingResponse pending(Pending pending) {
        try {
            return this.service.pending(pending);
        }
        catch (WebServiceException ex) {
            throw new AisClientException(ex);
        }
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    @Override
    public SignResponse sign(SignRequest signRequest) {
        try {
            return this.service.sign(signRequest);
        }
        catch (WebServiceException ex) {
            throw new AisClientException(ex);
        }
    }
}

