/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.ais;

import com.swisscom.ais.service.IDigitalSignatureService;
import com.swisscom.ais.service.Pending;
import com.swisscom.ais.service.PendingResponse;
import de.intarsys.ais.AisClientException;
import de.intarsys.ais.ConsentProvider;
import de.intarsys.ais.IConsentProvider;
import de.intarsys.ais.PendingRequestBuilder;
import de.intarsys.ais.PendingResponseFacade;
import de.intarsys.ais.ResponseTimeOutException;
import de.intarsys.ais.ResultException;
import de.intarsys.ais.SignRequestBuilder;
import de.intarsys.ais.SignRequestFacade;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.exception.ExceptionTools;
import java.io.IOException;
import oasis.names.tc.dss._1_0.core.schema.ClaimedIdentity;
import oasis.names.tc.dss._1_0.core.schema.SignRequest;
import oasis.names.tc.dss._1_0.core.schema.SignResponse;
import oasis.names.tc.dss._1_0.profiles.asynchronousprocessing._1.PendingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AisSyncAsyncClient
implements IDigitalSignatureService {
    private static final Logger Log = LoggerFactory.getLogger(AisSyncAsyncClient.class);
    protected static final Attribute ATTR_SYNCASYNC = new Attribute("syncAsync");
    private int delay = 4000;
    private int maxRetries = 120;
    private IDigitalSignatureService baseClient;

    public static IDigitalSignatureService create(IDigitalSignatureService baseClient) {
        IDigitalSignatureService syncAsyncClient = null;
        if (baseClient instanceof IAttributeSupport) {
            syncAsyncClient = (IDigitalSignatureService)((IAttributeSupport)baseClient).getAttribute((Object)ATTR_SYNCASYNC);
        }
        if (syncAsyncClient == null) {
            syncAsyncClient = new AisSyncAsyncClient(baseClient);
            if (baseClient instanceof IAttributeSupport) {
                ((IAttributeSupport)baseClient).setAttribute((Object)ATTR_SYNCASYNC, (Object)syncAsyncClient);
            }
        }
        return syncAsyncClient;
    }

    public AisSyncAsyncClient(IDigitalSignatureService baseClient) {
        this.baseClient = baseClient;
    }

    @Override
    public PendingResponse pending(Pending pending) {
        throw new UnsupportedOperationException();
    }

    protected SignResponse pollForResponse(String identityString, String responseID) {
        PendingRequestBuilder builder = new PendingRequestBuilder();
        ((PendingRequestBuilder)((PendingRequestBuilder)builder.withSwisscomProfile()).withClaimedIdentity(identityString)).withResponseID(responseID);
        PendingRequest pendingRequest = (PendingRequest)builder.getBaseRequest();
        SignResponse response = null;
        int multiplier = 5;
        for (int count = 0; count < this.maxRetries; ++count) {
            ThreadTools.sleep((long)(this.delay * multiplier));
            multiplier = 1;
            try {
                Pending pending = new Pending();
                pending.setPendingRequest(pendingRequest);
                PendingResponse pendingResponse = this.baseClient.pending(pending);
                response = pendingResponse.getSignResponse();
            }
            catch (AisClientException ex) {
                if (ExceptionTools.isInChain((Throwable)ex, IOException.class)) {
                    Log.warn(ex.getMessage(), (Throwable)ex);
                    continue;
                }
                throw ex;
            }
            try {
                new PendingResponseFacade(response);
                continue;
            }
            catch (ResultException ex) {
                return response;
            }
        }
        throw new ResponseTimeOutException();
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignResponse sign(SignRequest signRequest) {
        PendingResponseFacade responseFacade;
        SignRequestFacade requestFacade = new SignRequestFacade(signRequest);
        if (requestFacade.isAsynchronousProfile()) {
            throw new IllegalArgumentException();
        }
        SignRequestBuilder builder = new SignRequestBuilder(signRequest);
        builder.withAdditionalProfileAsync().withAdditionalProfileRedirect();
        SignResponse response = this.baseClient.sign(signRequest);
        try {
            responseFacade = new PendingResponseFacade(response);
        }
        catch (ResultException ex) {
            return response;
        }
        String consentUrl = responseFacade.getConsentUrl();
        IConsentProvider consentProvider = null;
        if (consentUrl != null) {
            consentProvider = ConsentProvider.get();
            consentProvider.requestConsent(consentUrl);
        }
        String identityString = null;
        for (Object object : signRequest.getOptionalInputs().getAny()) {
            if (!(object instanceof ClaimedIdentity)) continue;
            ClaimedIdentity claimedIdentity = (ClaimedIdentity)object;
            identityString = claimedIdentity.getName().getValue();
        }
        try {
            SignResponse signResponse = this.pollForResponse(identityString, responseFacade.getResponseID());
            return signResponse;
        }
        finally {
            if (consentProvider != null) {
                consentProvider.close();
            }
        }
    }
}

