/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.ais;

import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import oasis.names.tc.dss._1_0.core.schema.AnyType;
import oasis.names.tc.dss._1_0.core.schema.ClaimedIdentity;
import oasis.names.tc.dss._1_0.core.schema.ObjectFactory;
import oasis.names.tc.dss._1_0.core.schema.RequestBaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class BaseRequestBuilder<T extends RequestBaseType, I extends BaseRequestBuilder<T, I>> {
    private static final Logger Log = LoggerFactory.getLogger(BaseRequestBuilder.class);
    public static MessageFormat FormatClaimedIdentity = new MessageFormat("{0}:{1}");
    protected T baseRequest;
    protected final ObjectFactory coreObjectFactory = new ObjectFactory();
    protected final oasis.names.tc.saml._1_0.assertion.ObjectFactory samlObjectFactory = new oasis.names.tc.saml._1_0.assertion.ObjectFactory();
    private IArgs loggables = Args.create();
    private Level level = Level.DEBUG;

    protected BaseRequestBuilder() {
    }

    protected BaseRequestBuilder(T baseRequest) {
        this.baseRequest = baseRequest;
    }

    public T getBaseRequest() {
        if (Log.isEnabledForLevel(this.getLevel())) {
            Args resolved = Args.create();
            for (IArgs.IBinding b : IterableTools.in((Iterator)this.loggables.bindings())) {
                resolved.put(b.getName(), Optional.ofNullable((Supplier)b.getValue()).orElse(() -> null).get());
            }
            Log.atLevel(this.getLevel()).log("Creating request: {}", (Object)ArgTools.toArgString((IArgs)resolved));
        }
        return this.baseRequest;
    }

    public Level getLevel() {
        return this.level;
    }

    protected AnyType getOptionalInputs() {
        AnyType any = this.baseRequest.getOptionalInputs();
        if (any == null) {
            any = this.coreObjectFactory.createAnyType();
            this.baseRequest.setOptionalInputs(any);
        }
        return any;
    }

    protected void log(String name, Supplier<Object> value) {
        this.loggables.put(name, value);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public I withAdditionalProfile(String profileString) {
        this.log("additionalProfile " + profileString, null);
        this.getOptionalInputs().getAny().add(this.coreObjectFactory.createAdditionalProfile(profileString));
        return (I)this;
    }

    public I withClaimedIdentity(String identityString) {
        this.log("claimedIdentity", () -> identityString);
        ClaimedIdentity claimedIdentity = this.coreObjectFactory.createClaimedIdentity();
        claimedIdentity.setName(this.samlObjectFactory.createNameIdentifierType());
        claimedIdentity.getName().setValue(identityString);
        this.getOptionalInputs().getAny().add(claimedIdentity);
        return (I)this;
    }

    public I withClaimedIdentity(String customerName, String keyEntity) {
        String claimedIdentity = keyEntity == null ? customerName : FormatClaimedIdentity.format(new Object[]{customerName, keyEntity});
        return this.withClaimedIdentity(claimedIdentity);
    }

    public I withProfile(String profileString) {
        this.log("profile", () -> profileString);
        this.baseRequest.setProfile(profileString);
        return (I)this;
    }

    public I withRequestID(String requestID) {
        this.log("requestID", () -> requestID);
        this.baseRequest.setRequestID(requestID);
        return (I)this;
    }

    public I withSwisscomProfile() {
        return this.withProfile("http://ais.swisscom.ch/1.1");
    }
}

