/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.ais;

import de.intarsys.ais.ResponseInvalidException;
import de.intarsys.ais.ResultException;
import oasis.names.tc.dss._1_0.core.schema.Result;
import oasis.names.tc.dss._1_0.core.schema.SignResponse;

public abstract class BaseResponseFacade {
    protected final SignResponse oasisResponse;
    private String profile;
    private String requestID;

    protected BaseResponseFacade(SignResponse oasisResponse) {
        if (oasisResponse == null) {
            throw new ResponseInvalidException();
        }
        this.oasisResponse = oasisResponse;
        this.initializeProfile();
        this.initializeRequestID();
    }

    protected void expectResultMajor(String ... strings) {
        Result result = this.oasisResponse.getResult();
        if (result == null) {
            throw new ResponseInvalidException();
        }
        String resultMajor = result.getResultMajor();
        for (String string : strings) {
            if (!string.equals(resultMajor)) continue;
            return;
        }
        throw new ResultException(result);
    }

    public String getProfile() {
        return this.profile;
    }

    public String getRequestID() {
        return this.requestID;
    }

    protected void initializeProfile() {
        this.profile = this.oasisResponse.getProfile();
        if (!"http://ais.swisscom.ch/1.1".equals(this.profile)) {
            throw new ResponseInvalidException();
        }
    }

    protected void initializeRequestID() {
        this.requestID = this.oasisResponse.getRequestID();
    }
}

