/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.ais;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private final SSLSocketFactory wrappedFactory;
    private final SSLParameters sslParameters;

    public SSLSocketFactoryWrapper(SSLSocketFactory factory, SSLParameters sslParameters) {
        this.wrappedFactory = factory;
        this.sslParameters = sslParameters;
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket socket = (SSLSocket)this.wrappedFactory.createSocket();
        this.setParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.wrappedFactory.createSocket(host, port);
        this.setParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.wrappedFactory.createSocket(address, port, localAddress, localPort);
        this.setParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.wrappedFactory.createSocket(s, host, port, autoClose);
        this.setParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.wrappedFactory.createSocket(host, port);
        this.setParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.wrappedFactory.createSocket(host, port, localHost, localPort);
        this.setParameters(socket);
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.wrappedFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.wrappedFactory.getSupportedCipherSuites();
    }

    private void setParameters(SSLSocket socket) {
        socket.setSSLParameters(this.sslParameters);
    }
}

