/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.ais;

import ch.swisscom.ais._1_0.schema.AddRevocationInformationType;
import ch.swisscom.ais._1_0.schema.CertificateRequestType;
import ch.swisscom.ais._1_0.schema.PhoneType;
import ch.swisscom.ais._1_0.schema.StepUpAuthorisationType;
import de.intarsys.ais.BaseRequestBuilder;
import de.intarsys.ais.SignatureStandard;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.hex.HexTools;
import jakarta.xml.bind.JAXBElement;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import oasis.names.tc.dss._1_0.core.schema.DocumentHash;
import oasis.names.tc.dss._1_0.core.schema.InputDocuments;
import oasis.names.tc.dss._1_0.core.schema.SignRequest;
import oasis.names.tc.dss._1_0.core.schema.UpdateSignatureInstructionType;
import org.w3._2000._09.xmldsig.DigestMethodType;
import org.w3._2000._09.xmldsig.ObjectFactory;

public class SignRequestBuilder
extends BaseRequestBuilder<SignRequest, SignRequestBuilder> {
    private static final QName SIGNATURE_STANDARD_QNAME = new QName("http://ais.swisscom.ch/1.0/schema", "SignatureStandard");
    private static final List<String> SIGNATURE_STANDARDS = ListTools.with((Object[])new String[]{"cades", "pades", "pades_baseline"});
    private final ch.swisscom.ais._1_0.schema.ObjectFactory swisscomObjectFactory = new ch.swisscom.ais._1_0.schema.ObjectFactory();
    private final ObjectFactory xmldsigObjectFactory = new ObjectFactory();

    public SignRequestBuilder() {
        this.baseRequest = this.coreObjectFactory.createSignRequest();
    }

    public SignRequestBuilder(SignRequest signRequest) {
        super(signRequest);
    }

    protected InputDocuments getInputDocuments() {
        InputDocuments inputDocuments = ((SignRequest)this.baseRequest).getInputDocuments();
        if (inputDocuments == null) {
            inputDocuments = this.coreObjectFactory.createInputDocuments();
            ((SignRequest)this.baseRequest).setInputDocuments(inputDocuments);
        }
        return inputDocuments;
    }

    public SignRequestBuilder withAdditionalProfileAsync() {
        return (SignRequestBuilder)this.withAdditionalProfile("urn:oasis:names:tc:dss:1.0:profiles:asynchronousprocessing");
    }

    public SignRequestBuilder withAdditionalProfileBatchProcessing() {
        return (SignRequestBuilder)this.withAdditionalProfile("http://ais.swisscom.ch/1.0/profiles/batchprocessing");
    }

    public SignRequestBuilder withAdditionalProfileOnDemand() {
        return (SignRequestBuilder)this.withAdditionalProfile("http://ais.swisscom.ch/1.0/profiles/ondemandcertificate");
    }

    public SignRequestBuilder withAdditionalProfileRedirect() {
        return (SignRequestBuilder)this.withAdditionalProfile("http://ais.swisscom.ch/1.1/profiles/redirect");
    }

    public SignRequestBuilder withAdditionalProfileTimestamping() {
        return (SignRequestBuilder)this.withAdditionalProfile("urn:oasis:names:tc:dss:1.0:profiles:timestamping");
    }

    public SignRequestBuilder withAddOcspResponse(String type) {
        UpdateSignatureInstructionType instruction = null;
        if (type != null) {
            instruction = this.coreObjectFactory.createUpdateSignatureInstructionType();
            instruction.setType(type);
        }
        this.getOptionalInputs().getAny().add(this.swisscomObjectFactory.createAddOcspResponse(instruction));
        return this;
    }

    public SignRequestBuilder withAddRevocationInformation() {
        return this.withAddRevocationInformation(null);
    }

    public SignRequestBuilder withAddRevocationInformation(String type) {
        AddRevocationInformationType info = this.swisscomObjectFactory.createAddRevocationInformationType();
        info.setType(type);
        this.getOptionalInputs().getAny().add(this.swisscomObjectFactory.createAddRevocationInformation(info));
        return this;
    }

    public SignRequestBuilder withAddTimestamp(String type) {
        UpdateSignatureInstructionType instruction = null;
        if (type != null) {
            instruction = this.coreObjectFactory.createUpdateSignatureInstructionType();
            instruction.setType(type);
        }
        this.getOptionalInputs().getAny().add(this.coreObjectFactory.createAddTimestamp(instruction));
        return this;
    }

    public SignRequestBuilder withCertificateRequest(String distinguishedNameString) {
        this.log("distinguishedName", () -> distinguishedNameString);
        CertificateRequestType certificateRequest = new CertificateRequestType();
        certificateRequest.setDistinguishedName(distinguishedNameString);
        this.getOptionalInputs().getAny().add(this.swisscomObjectFactory.createCertificateRequest(certificateRequest));
        return this;
    }

    public SignRequestBuilder withCertificateRequest(String distinguishedNameString, StepUpAuthorisationType stepUpAuthorisation) {
        this.log("csr.distinguishedName", () -> distinguishedNameString);
        CertificateRequestType certificateRequest = new CertificateRequestType();
        certificateRequest.setDistinguishedName(distinguishedNameString);
        if (stepUpAuthorisation != null) {
            certificateRequest.setStepUpAuthorisation(stepUpAuthorisation);
        }
        this.getOptionalInputs().getAny().add(this.swisscomObjectFactory.createCertificateRequest(certificateRequest));
        return this;
    }

    public SignRequestBuilder withCertificateRequest(String distinguishedNameString, String language, String messageString, String msisdnString) {
        StepUpAuthorisationType stepUpAuthorisation = null;
        if (msisdnString != null) {
            stepUpAuthorisation = new StepUpAuthorisationType();
            PhoneType phone = new PhoneType();
            phone.setLanguage(language);
            this.log("stepup.language", () -> language);
            phone.setMessage(messageString);
            this.log("stepup.message", () -> messageString);
            phone.setMSISDN(msisdnString);
            this.log("stepup.msisdn", () -> msisdnString);
            stepUpAuthorisation.setPhone(phone);
        }
        return this.withCertificateRequest(distinguishedNameString, stepUpAuthorisation);
    }

    public SignRequestBuilder withCertificateRequestTest(String distinguishedNameString, String msisdnString) {
        this.withCertificateRequest(distinguishedNameString, "EN", "Please confirm", msisdnString);
        return this;
    }

    public SignRequestBuilder withDocumentHash(String algorithm, byte[] digestValue) {
        return this.withDocumentHash(null, algorithm, digestValue);
    }

    public SignRequestBuilder withDocumentHash(String id, String algorithm, byte[] digestValue) {
        this.log("document.id", () -> id);
        this.log("document.algorithm", () -> algorithm);
        this.log("document.digestValue", () -> HexTools.bytesToHexString((byte[])digestValue));
        DocumentHash documentHash = this.coreObjectFactory.createDocumentHash();
        documentHash.setID(id);
        DigestMethodType digestMethod = this.xmldsigObjectFactory.createDigestMethodType();
        digestMethod.setAlgorithm(algorithm);
        documentHash.setDigestMethod(digestMethod);
        documentHash.setDigestValue(digestValue);
        this.getInputDocuments().getDocumentOrTransformedDataOrDocumentHash().add(documentHash);
        return this;
    }

    public SignRequestBuilder withDocumentHashDummy() {
        byte[] digest = new byte[32];
        Arrays.fill(digest, (byte)7);
        return this.withDocumentHash("http://www.w3.org/2001/04/xmlenc#sha256", digest);
    }

    public SignRequestBuilder withSignatureStandard(SignatureStandard standard) {
        this.log("signatureStandard", () -> standard);
        this.getOptionalInputs().getAny().add(new JAXBElement(SIGNATURE_STANDARD_QNAME, String.class, (Object)standard.name()));
        return this;
    }

    public SignRequestBuilder withSignatureType(String typeString) {
        this.log("type", () -> typeString);
        this.getOptionalInputs().getAny().add(this.coreObjectFactory.createSignatureType(typeString));
        return this;
    }

    public SignRequestBuilder withSignatureTypeCms() {
        return this.withSignatureType("urn:ietf:rfc:3369");
    }

    public SignRequestBuilder withSignatureTypeTimestamp() {
        return this.withSignatureType("urn:ietf:rfc:3161");
    }
}

