/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.ais;

import ch.swisscom.ais._1_0.schema.ExtendedSignatureObjectType;
import ch.swisscom.ais._1_0.schema.SignatureObjectsType;
import de.intarsys.ais.ResponseInvalidException;
import de.intarsys.ais.SignResponseFacade;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.exception.InvalidRequestException;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import oasis.names.tc.dss._1_0.core.schema.Base64Signature;
import oasis.names.tc.dss._1_0.core.schema.SignResponse;
import oasis.names.tc.dss._1_0.core.schema.SignatureObject;

public class SignResponseFacadeSignature
extends SignResponseFacade {
    private byte[] signature;
    private List<byte[]> signatures;

    public SignResponseFacadeSignature(SignResponse baseResponse) {
        super(baseResponse);
        this.initializeSignatures();
    }

    public byte[] getSignature() {
        if (this.signature == null) {
            throw new InvalidRequestException();
        }
        return this.signature;
    }

    public List<byte[]> getSignatures() {
        return this.signatures;
    }

    protected void initializeSignatures() {
        SignatureObject signatureObject = this.oasisResponse.getSignatureObject();
        if (signatureObject == null) {
            throw new ResponseInvalidException();
        }
        Base64Signature base64Signature = signatureObject.getBase64Signature();
        if (base64Signature == null) {
            SignatureObjectsType signatureObjects = (SignatureObjectsType)((JAXBElement)signatureObject.getOther().getAny().get(0)).getValue();
            List<ExtendedSignatureObjectType> extendedSignatureObjectList = signatureObjects.getExtendedSignatureObject();
            int size = extendedSignatureObjectList.size();
            this.signatures = new ArrayList<byte[]>(size);
            for (int index = 0; index < size; ++index) {
                ExtendedSignatureObjectType extendedSignatureObject = extendedSignatureObjectList.get(index);
                base64Signature = extendedSignatureObject.getBase64Signature();
                this.signatures.add(base64Signature.getValue());
            }
        } else {
            this.signature = base64Signature.getValue();
            this.signatures = ListTools.with((Object[])new byte[][]{this.signature});
        }
    }
}

