/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.ais.certificate;

import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class SwisscomX500NameStyle
extends BCStyle {
    public static final X500NameStyle INSTANCE = new SwisscomX500NameStyle();
    private static final Hashtable LookUp = new Hashtable();
    private static final Hashtable Symbols = new Hashtable();

    protected SwisscomX500NameStyle() {
    }

    public boolean areEqual(X500Name name1, X500Name name2) {
        return super.areEqual(name1, name2);
    }

    public ASN1ObjectIdentifier attrNameToOID(String attrName) {
        return IETFUtils.decodeAttrName((String)attrName, (Hashtable)LookUp);
    }

    public int calculateHashCode(X500Name name) {
        return super.calculateHashCode(name);
    }

    public RDN[] fromString(String dirName) {
        return super.fromString(dirName);
    }

    public ASN1Encodable stringToValue(ASN1ObjectIdentifier oid, String value) {
        if (oid.equals((ASN1Primitive)C) || oid.equals((ASN1Primitive)SN)) {
            return new DERPrintableString(value, true);
        }
        return super.stringToValue(oid, value);
    }

    public String toString(X500Name name) {
        StringBuffer builder = new StringBuffer();
        RDN[] rdns = name.getRDNs();
        for (int i = 0; i < rdns.length; ++i) {
            if (rdns[i].isMultiValued()) {
                AttributeTypeAndValue[] atv = rdns[i].getTypesAndValues();
                boolean firstAtv = true;
                for (int j = 0; j != atv.length; ++j) {
                    ASN1Encodable value = atv[j].getValue();
                    if (value.toString().isEmpty()) continue;
                    if (firstAtv) {
                        firstAtv = false;
                    } else {
                        builder.append('+');
                    }
                    IETFUtils.appendTypeAndValue((StringBuffer)builder, (AttributeTypeAndValue)atv[j], (Hashtable)Symbols);
                }
                continue;
            }
            ASN1Encodable value = rdns[i].getFirst().getValue();
            if (value.toString().isEmpty()) continue;
            if (builder.length() != 0) {
                builder.append(',');
            }
            IETFUtils.appendTypeAndValue((StringBuffer)builder, (AttributeTypeAndValue)rdns[i].getFirst(), (Hashtable)Symbols);
        }
        return builder.toString();
    }

    static {
        Symbols.put(CN, "CN");
        Symbols.put(C, "C");
        Symbols.put(EmailAddress, "EMAILADDRESS");
        Symbols.put(GIVENNAME, "GIVENNAME");
        Symbols.put(PSEUDONYM, "PSEUDONYM");
        Symbols.put(SURNAME, "SN");
        Symbols.put(SURNAME, "SURNAME");
        Symbols.put(L, "L");
        Symbols.put(OU, "OU");
        Symbols.put(O, "O");
        Symbols.put(SN, "SERIALNUMBER");
        Symbols.put(ST, "ST");
        LookUp.put("cn", CN);
        LookUp.put("commonname", CN);
        LookUp.put("c", C);
        LookUp.put("countryname", C);
        LookUp.put("emailaddress", EmailAddress);
        LookUp.put("givenname", GIVENNAME);
        LookUp.put("pseudonym", PSEUDONYM);
        LookUp.put("sn", SURNAME);
        LookUp.put("surname", SURNAME);
        LookUp.put("l", L);
        LookUp.put("localityname", L);
        LookUp.put("ou", OU);
        LookUp.put("organizationalunitname", OU);
        LookUp.put("o", O);
        LookUp.put("organizationname", O);
        LookUp.put("serialnumber", SN);
        LookUp.put("st", ST);
        LookUp.put("stateorprovincename", ST);
    }
}

