/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.ras;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import de.intarsys.ras.ErrorDto;
import de.intarsys.ras.Evidence;
import de.intarsys.ras.EvidenceApi;
import de.intarsys.ras.EvidenceValidationPost;
import de.intarsys.ras.EvidenceVerificationException;
import de.intarsys.tools.ssl.SslContextProvider;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasClient
implements EvidenceApi {
    private static final Logger Log = LoggerFactory.getLogger(RasClient.class);
    private WebTarget target;

    public RasClient(String baseUri) {
        try {
            SSLContext context = SslContextProvider.get().createSslContext();
            Client client = ((ClientBuilder)ClientBuilder.newBuilder().sslContext(context).register(JacksonJsonProvider.class)).build();
            this.target = client.target(baseUri);
        }
        catch (Exception ex) {
            Log.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public Evidence evidencesVerifyPost(EvidenceValidationPost body) throws EvidenceVerificationException {
        Entity entity = Entity.entity((Object)body, (String)"application/vnd.sc.ras.evidence.v1+json");
        try {
            return (Evidence)this.target.path("/evidences/verify").request().post(entity, Evidence.class);
        }
        catch (WebApplicationException e) {
            Object message = this.getMessage(e);
            String hint = this.getHint(e);
            if (hint != null) {
                message = (String)message + " (Hint: " + hint + ")";
            }
            Log.warn("Identity verification error: {}", message);
            throw new EvidenceVerificationException("Identity verification error: " + (String)message, e);
        }
    }

    protected String getHint(WebApplicationException e) {
        return switch (e.getResponse().getStatus()) {
            case 402 -> "It seems your identification is not available in the requested jurisdiction. Please identify again to be able to sign.";
            case 404 -> "Is the ID expired? Is the evidence older than 5 years?";
            case 500 -> "It seems that one of the entered data is not correct.";
            case 502, 503 -> "It seems that the RA service is temporarily unavailable. Please try later.";
            default -> null;
        };
    }

    protected String getMessage(WebApplicationException e) {
        Response response = e.getResponse();
        if (!response.hasEntity()) {
            return e.getMessage();
        }
        String message = null;
        try {
            ErrorDto error = (ErrorDto)response.readEntity(ErrorDto.class);
            Log.debug("ErrorDto: {}", (Object)error);
            message = error.getMessage();
            if (message == null) {
                message = error.toString();
            }
        }
        catch (Exception ex) {
            message = (String)response.readEntity(String.class);
        }
        return message;
    }
}

